/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.swing.DoubleTextField;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PlotMarginsDialog
extends JDialog {
    private static final int GAP = 10;
    private DoubleTextField myTopMargin;
    private DoubleTextField myLeftMargin;
    private DoubleTextField myBottomMargin;
    private DoubleTextField myRightMargin;
    private boolean okButtonClicked;

    public PlotMarginsDialog(Frame frame) {
        super(frame, "Format Margins", true);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Top Margin");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myTopMargin = new DoubleTextField(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myTopMargin, gridBagConstraints);
        container.add(this.myTopMargin);
        jLabel = new JLabel("Left Margin");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myLeftMargin = new DoubleTextField(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myLeftMargin, gridBagConstraints);
        container.add(this.myLeftMargin);
        jLabel = new JLabel("Bottom Margin");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myBottomMargin = new DoubleTextField(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myBottomMargin, gridBagConstraints);
        container.add(this.myBottomMargin);
        jLabel = new JLabel("Right Margin");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myRightMargin = new DoubleTextField(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myRightMargin, gridBagConstraints);
        container.add(this.myRightMargin);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotMarginsDialog.this.doOkay();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotMarginsDialog.this.doCancel();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        this.getRootPane().setDefaultButton(jButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                PlotMarginsDialog.this.myTopMargin.setSelectionStart(Integer.MAX_VALUE);
                PlotMarginsDialog.this.myTopMargin.setSelectionEnd(Integer.MAX_VALUE);
                PlotMarginsDialog.this.myTopMargin.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent windowEvent) {
                PlotMarginsDialog.this.doCancel();
            }
        });
        this.pack();
    }

    public void setTopMargin(double d) {
        this.myTopMargin.value(d);
    }

    public void setLeftMargin(double d) {
        this.myLeftMargin.value(d);
    }

    public void setBottomMargin(double d) {
        this.myBottomMargin.value(d);
    }

    public void setRightMargin(double d) {
        this.myRightMargin.value(d);
    }

    public boolean isOkay() {
        return this.okButtonClicked;
    }

    public double getTopMargin() {
        return this.myTopMargin.value();
    }

    public double getLeftMargin() {
        return this.myLeftMargin.value();
    }

    public double getBottomMargin() {
        return this.myBottomMargin.value();
    }

    public double getRightMargin() {
        return this.myRightMargin.value();
    }

    private void doOkay() {
        if (this.myTopMargin.isOkay(0.0, Double.MAX_VALUE) && this.myLeftMargin.isOkay(0.0, Double.MAX_VALUE) && this.myBottomMargin.isOkay(0.0, Double.MAX_VALUE) && this.myRightMargin.isOkay(0.0, Double.MAX_VALUE)) {
            this.okButtonClicked = true;
            this.setVisible(false);
        }
    }

    private void doCancel() {
        this.okButtonClicked = false;
        this.setVisible(false);
    }
}

