/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.DomainException;

public class Tridiagonal {
    private Tridiagonal() {
    }

    public static void solve(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        int n;
        int n2 = dArray.length;
        if (n2 < 2) {
            throw new IllegalArgumentException("Tridiagonal.solve(): d.length = " + dArray.length + " illegal");
        }
        if (dArray2.length != n2 - 1) {
            throw new IllegalArgumentException("Tridiagonal.solve(): e.length = " + dArray2.length + " illegal");
        }
        if (dArray3.length != n2 - 1) {
            throw new IllegalArgumentException("Tridiagonal.solve(): f.length = " + dArray3.length + " illegal");
        }
        if (dArray4.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solve(): b.length = " + dArray4.length + " illegal");
        }
        if (dArray5.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solve(): x.length = " + dArray5.length + " illegal");
        }
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        dArray6[0] = dArray[0];
        dArray7[0] = dArray4[0];
        if (dArray6[0] == 0.0) {
            throw new DomainException("Tridiagonal.solve(): Zero on diagonal");
        }
        for (n = 1; n < n2; ++n) {
            double d = dArray3[n - 1] / dArray6[n - 1];
            dArray6[n] = dArray[n] - d * dArray2[n - 1];
            dArray7[n] = dArray4[n] - d * dArray7[n - 1];
            if (dArray6[n] != 0.0) continue;
            throw new DomainException("Tridiagonal.solve(): Zero on diagonal");
        }
        n = n2 - 1;
        dArray5[n] = dArray7[n] / dArray6[n];
        for (int i = n2 - 2; i >= 0; --i) {
            dArray5[i] = (dArray7[i] - dArray2[i] * dArray5[i + 1]) / dArray6[i];
        }
    }

    public static void solveSymmetric(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        Tridiagonal.solve(dArray, dArray2, dArray2, dArray3, dArray4);
    }

    public static void solveCyclic(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d;
        int n;
        int n2 = dArray.length;
        if (n2 < 3) {
            throw new IllegalArgumentException("Tridiagonal.solveCyclic(): d.length = " + dArray.length + " illegal");
        }
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveCyclic(): e.length = " + dArray2.length + " illegal");
        }
        if (dArray3.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveCyclic(): f.length = " + dArray3.length + " illegal");
        }
        if (dArray4.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveCyclic(): b.length = " + dArray4.length + " illegal");
        }
        if (dArray5.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveCyclic(): x.length = " + dArray5.length + " illegal");
        }
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n2];
        if (dArray[0] == 0.0 || dArray[1] == 0.0) {
            throw new DomainException("Tridiagonal.solveCyclic(): Zero on diagonal");
        }
        dArray7[0] = dArray4[0];
        double d2 = 1.0 - dArray2[0] * dArray3[0] / (dArray[0] * dArray[1]);
        double d3 = -dArray[0];
        double d4 = Math.abs(d2 / d3);
        if (!(d4 <= 0.5)) {
            if (d4 < 1.0) {
                d3 *= 0.5;
            } else if (d4 < 2.0) {
                d3 *= 2.0;
            }
        }
        dArray8[0] = d3;
        dArray6[0] = dArray[0] - d3;
        if (dArray6[0] == 0.0) {
            throw new DomainException("Tridiagonal.solveCyclic(): Zero on diagonal");
        }
        int n3 = n2 - 1;
        for (n = 1; n < n3; ++n) {
            d = dArray3[n - 1] / dArray6[n - 1];
            dArray6[n] = dArray[n] - d * dArray2[n - 1];
            dArray7[n] = dArray4[n] - d * dArray7[n - 1];
            dArray8[n] = -d * dArray8[n - 1];
            if (dArray6[n] != 0.0) continue;
            throw new DomainException("Tridiagonal.solveCyclic(): Zero on diagonal");
        }
        n = n2 - 2;
        d = dArray3[n] / dArray6[n];
        dArray6[n3] = dArray[n3] - dArray2[n3] * dArray3[n3] / d3 - d * dArray2[n];
        dArray7[n3] = dArray4[n3] - d * dArray7[n];
        dArray8[n3] = dArray2[n3] - d * dArray8[n];
        if (dArray6[n3] == 0.0) {
            throw new DomainException("Tridiagonal.solveCyclic(): Zero on diagonal");
        }
        dArray9[n3] = dArray8[n3] / dArray6[n3];
        dArray5[n3] = dArray7[n3] / dArray6[n3];
        for (int i = n; i >= 0; --i) {
            dArray9[i] = (dArray8[i] - dArray2[i] * dArray9[i + 1]) / dArray6[i];
            dArray5[i] = (dArray7[i] - dArray2[i] * dArray5[i + 1]) / dArray6[i];
        }
        double d5 = dArray9[0] + dArray3[n3] / d3 * dArray9[n3] + 1.0;
        double d6 = dArray5[0] + dArray3[n3] / d3 * dArray5[n3];
        if (d5 == 0.0) {
            throw new DomainException("Tridiagonal.solveCyclic(): Zero on diagonal");
        }
        double d7 = d6 / d5;
        for (int i = 0; i < n2; ++i) {
            int n4 = i;
            dArray5[n4] = dArray5[n4] - d7 * dArray9[i];
        }
    }

    public static void solveSymmetricCyclic(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2 = dArray.length;
        if (n2 < 3) {
            throw new IllegalArgumentException("Tridiagonal.solveSymmetricCyclic(): d.length = " + dArray.length + " illegal");
        }
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveSymmetricCyclic(): e.length = " + dArray2.length + " illegal");
        }
        if (dArray3.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveSymmetricCyclic(): b.length = " + dArray3.length + " illegal");
        }
        if (dArray4.length != n2) {
            throw new IllegalArgumentException("Tridiagonal.solveSymmetricCyclic(): x.length = " + dArray4.length + " illegal");
        }
        double[] dArray5 = new double[n2];
        double[] dArray6 = new double[n2];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n2];
        double d = 0.0;
        int n3 = n2 - 1;
        int n4 = n2 - 2;
        int n5 = n2 - 3;
        if (dArray[0] == 0.0) {
            throw new DomainException("Tridiagonal.solveSymmetricCyclic(): Zero on diagonal");
        }
        dArray5[0] = dArray[0];
        dArray6[0] = dArray2[0] / dArray5[0];
        dArray7[0] = dArray2[n3] / dArray5[0];
        d += dArray5[0] * dArray7[0] * dArray7[0];
        for (n = 1; n < n4; ++n) {
            dArray5[n] = dArray[n] - dArray2[n - 1] * dArray6[n - 1];
            if (dArray5[n] == 0.0) {
                throw new DomainException("Tridiagonal.solveSymmetricCyclic(): Zero on diagonal");
            }
            dArray6[n] = dArray2[n] / dArray5[n];
            dArray7[n] = -dArray7[n - 1] * dArray2[n - 1] / dArray5[n];
            d += dArray5[n] * dArray7[n] * dArray7[n];
        }
        dArray5[n4] = dArray[n4] - dArray2[n5] * dArray6[n5];
        dArray6[n4] = (dArray2[n4] - dArray2[n5] * dArray7[n5]) / dArray5[n4];
        dArray5[n3] = dArray[n3] - d - dArray5[n4] * dArray6[n4] * dArray6[n4];
        dArray9[0] = dArray3[0];
        for (n = 1; n < n3; ++n) {
            dArray9[n] = dArray3[n] - dArray9[n - 1] * dArray6[n - 1];
        }
        d = 0.0;
        for (n = 0; n < n4; ++n) {
            d += dArray7[n] * dArray9[n];
        }
        dArray9[n3] = dArray3[n3] - d - dArray6[n4] * dArray9[n4];
        for (n = 0; n < n2; ++n) {
            dArray8[n] = dArray9[n] / dArray5[n];
        }
        dArray4[n3] = dArray8[n3];
        dArray4[n4] = dArray8[n4] - dArray6[n4] * dArray4[n3];
        for (n = n5; n >= 0; --n) {
            dArray4[n] = dArray8[n] - dArray6[n] * dArray4[n + 1] - dArray7[n] * dArray4[n3];
        }
    }
}

