/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigRational
extends Number
implements Comparable<BigRational> {
    private BigInteger numer;
    private BigInteger denom;

    public BigRational() {
        this.numer = BigInteger.ZERO;
        this.denom = BigInteger.ONE;
    }

    public BigRational(long l) {
        this.assign(l);
    }

    public BigRational(long l, long l2) {
        this.assign(l, l2);
    }

    public BigRational(BigInteger bigInteger) {
        this.assign(bigInteger);
    }

    public BigRational(BigInteger bigInteger, BigInteger bigInteger2) {
        this.assign(bigInteger, bigInteger2);
    }

    public BigRational(BigRational bigRational) {
        this.assign(bigRational);
    }

    public BigRational(String string) {
        this.assign(string);
    }

    public BigInteger numerator() {
        return this.numer;
    }

    public BigInteger denominator() {
        return this.denom;
    }

    public BigRational assign(long l) {
        this.numer = BigInteger.valueOf(l);
        this.denom = BigInteger.ONE;
        return this;
    }

    public BigRational assign(long l, long l2) {
        if (l2 == 0L) {
            throw new ArithmeticException("BigRational.assign(): Zero denominator");
        }
        this.numer = BigInteger.valueOf(l);
        this.denom = BigInteger.valueOf(l2);
        return this;
    }

    public BigRational assign(BigInteger bigInteger) {
        this.numer = bigInteger;
        this.denom = BigInteger.ONE;
        return this;
    }

    public BigRational assign(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("BigRational.assign(): Zero denominator");
        }
        this.numer = bigInteger;
        this.denom = bigInteger2;
        return this;
    }

    public BigRational assign(BigRational bigRational) {
        this.numer = bigRational.numer;
        this.denom = bigRational.denom;
        return this;
    }

    public BigRational assign(String string) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n = string.indexOf(47);
        if (n == -1) {
            bigInteger2 = new BigInteger(string);
            bigInteger = BigInteger.ONE;
        } else if (n + 1 < string.length()) {
            bigInteger2 = new BigInteger(string.substring(0, n));
            bigInteger = new BigInteger(string.substring(n + 1));
            if (bigInteger.compareTo(BigInteger.ZERO) <= 0) {
                throw new NumberFormatException("BigRational.assign(): Negative denominator not allowed");
            }
        } else {
            throw new NumberFormatException("BigRational.assign(): Missing denominator after /");
        }
        this.numer = bigInteger2;
        this.denom = bigInteger;
        return this;
    }

    public BigRational intPart() {
        this.numer = this.numer.divide(this.denom);
        this.denom = BigInteger.ONE;
        return this;
    }

    public BigRational fracPart() {
        this.numer = this.numer.remainder(this.denom);
        return this;
    }

    public BigRational add(BigRational bigRational) {
        this.numer = this.numer.multiply(bigRational.denom).add(bigRational.numer.multiply(this.denom));
        this.denom = this.denom.multiply(bigRational.denom);
        return this;
    }

    public BigRational sub(BigRational bigRational) {
        this.numer = this.numer.multiply(bigRational.denom).subtract(bigRational.numer.multiply(this.denom));
        this.denom = this.denom.multiply(bigRational.denom);
        return this;
    }

    public BigRational mul(BigRational bigRational) {
        this.numer = this.numer.multiply(bigRational.numer);
        this.denom = this.denom.multiply(bigRational.denom);
        return this;
    }

    public BigRational div(BigRational bigRational) {
        if (bigRational.numer.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("BigRational.div(): Divide by zero");
        }
        this.numer = this.numer.multiply(bigRational.denom);
        this.denom = this.denom.multiply(bigRational.numer);
        return this;
    }

    public BigRational rem(BigRational bigRational) {
        return this.div(bigRational).fracPart().mul(bigRational);
    }

    public BigRational incr() {
        this.numer = this.numer.add(this.denom);
        return this;
    }

    public BigRational decr() {
        this.numer = this.numer.subtract(this.denom);
        return this;
    }

    public BigRational abs() {
        this.numer = this.numer.abs();
        this.denom = this.denom.abs();
        return this;
    }

    public BigRational negate() {
        this.numer = this.numer.negate();
        return this;
    }

    public BigRational recip() {
        if (this.numer.equals(BigInteger.ZERO)) {
            throw new ArithmeticException("BigRational.recip(): Divide by zero");
        }
        BigInteger bigInteger = this.numer;
        this.numer = this.denom;
        this.denom = bigInteger;
        return this;
    }

    public BigRational min(BigRational bigRational) {
        if (this.compareTo(bigRational) > 0) {
            this.assign(bigRational);
        }
        return this;
    }

    public BigRational max(BigRational bigRational) {
        if (this.compareTo(bigRational) < 0) {
            this.assign(bigRational);
        }
        return this;
    }

    public BigRational normalize() {
        int n = this.numer.signum() * this.denom.signum();
        this.numer = this.numer.abs();
        this.denom = this.denom.abs();
        BigInteger bigInteger = this.numer.gcd(this.denom);
        this.numer = this.numer.divide(bigInteger);
        this.denom = this.denom.divide(bigInteger);
        if (n < 0) {
            this.numer = this.numer.negate();
        }
        return this;
    }

    @Override
    public int intValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numer);
        BigDecimal bigDecimal2 = new BigDecimal(this.denom);
        return bigDecimal.divide(bigDecimal2, 1, RoundingMode.HALF_UP).intValue();
    }

    @Override
    public long longValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numer);
        BigDecimal bigDecimal2 = new BigDecimal(this.denom);
        return bigDecimal.divide(bigDecimal2, 1, RoundingMode.HALF_UP).longValue();
    }

    @Override
    public float floatValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numer);
        BigDecimal bigDecimal2 = new BigDecimal(this.denom);
        return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL32).floatValue();
    }

    @Override
    public double doubleValue() {
        BigDecimal bigDecimal = new BigDecimal(this.numer);
        BigDecimal bigDecimal2 = new BigDecimal(this.denom);
        return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL64).doubleValue();
    }

    @Override
    public int compareTo(BigRational bigRational) {
        BigInteger bigInteger = this.numer.multiply(bigRational.denom).subtract(bigRational.numer.multiply(this.denom));
        return bigInteger.compareTo(BigInteger.ZERO);
    }

    public boolean equals(Object object) {
        return object instanceof BigRational && ((BigRational)object).numer.equals(this.numer) && ((BigRational)object).denom.equals(this.denom);
    }

    public int hashCode() {
        return this.numer.hashCode() * 31 + this.denom.hashCode();
    }

    public String toString() {
        String string = this.numer.toString();
        String string2 = this.denom.toString();
        if (string.charAt(0) == '-' && string2.charAt(0) == '-') {
            string = string.substring(1);
            string2 = string2.substring(1);
        } else if (string.charAt(0) != '-' && string2.charAt(0) == '-') {
            string = "-" + string;
            string2 = string2.substring(1);
        }
        if (string2.equals("1")) {
            return string;
        }
        return string + "/" + string2;
    }
}

