/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp;

import edu.rit.mp.Buf;
import edu.rit.mp.MPObjectInputStream;
import edu.rit.mp.Status;
import edu.rit.mp.buf.EmptyObjectBuf;
import edu.rit.mp.buf.ObjectArrayBuf;
import edu.rit.mp.buf.ObjectArrayBuf_1;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.mp.buf.ObjectMatrixBuf;
import edu.rit.mp.buf.ObjectMatrixBuf_1;
import edu.rit.mp.buf.SharedObjectArrayBuf;
import edu.rit.mp.buf.SharedObjectArrayBuf_1;
import edu.rit.mp.buf.SharedObjectBuf;
import edu.rit.pj.reduction.SharedObject;
import edu.rit.pj.reduction.SharedObjectArray;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectBuf<T>
extends Buf {
    protected byte[] mySerializedItems;

    protected ObjectBuf(int n) {
        super((byte)9, n);
    }

    public static ObjectBuf<Object> emptyBuffer() {
        return new EmptyObjectBuf();
    }

    public static <T> ObjectItemBuf<T> buffer() {
        return new ObjectItemBuf();
    }

    public static <T> ObjectItemBuf<T> buffer(T t) {
        return new ObjectItemBuf<T>(t);
    }

    public static <T> ObjectBuf<T> buffer(T[] TArray) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theArray is null");
        }
        int n = Arrays.length(TArray);
        return new ObjectArrayBuf_1<T>(TArray, new Range(0, n - 1));
    }

    public static <T> ObjectBuf<T> sliceBuffer(T[] TArray, Range range) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.sliceBuffer(): theArray is null");
        }
        int n = Arrays.length(TArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ObjectBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new ObjectArrayBuf_1<T>(TArray, range);
        }
        return new ObjectArrayBuf<T>(TArray, range);
    }

    public static <T> ObjectBuf<T>[] sliceBuffers(T[] TArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ObjectBuf[] objectBufArray = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            objectBufArray[i] = ObjectBuf.sliceBuffer(TArray, rangeArray[i]);
        }
        return objectBufArray;
    }

    public static <T> ObjectItemBuf<T[]> objectBuffer(T[] TArray) {
        return new ObjectItemBuf<T[]>(TArray);
    }

    public static <T> ObjectBuf<T> buffer(T[][] TArray) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(TArray);
        int n2 = Arrays.colLength(TArray, 0);
        return new ObjectMatrixBuf_1<T>(TArray, new Range(0, n - 1), new Range(0, n2 - 1));
    }

    public static <T> ObjectBuf<T> rowSliceBuffer(T[][] TArray, Range range) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.rowSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(TArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ObjectBuf.rowSliceBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(TArray, range.lb());
        if (range.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(TArray, range, new Range(0, n2 - 1));
        }
        return new ObjectMatrixBuf<T>(TArray, range, new Range(0, n2 - 1));
    }

    public static <T> ObjectBuf<T>[] rowSliceBuffers(T[][] TArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ObjectBuf[] objectBufArray = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            objectBufArray[i] = ObjectBuf.rowSliceBuffer(TArray, rangeArray[i]);
        }
        return objectBufArray;
    }

    public static <T> ObjectBuf<T> colSliceBuffer(T[][] TArray, Range range) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.colSliceBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(TArray);
        int n2 = Arrays.colLength(TArray, 0);
        if (0 > range.lb() || range.ub() >= n2) {
            throw new IndexOutOfBoundsException("ObjectBuf.colSliceBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range);
        }
        if (range.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(TArray, new Range(0, n - 1), range);
        }
        return new ObjectMatrixBuf<T>(TArray, new Range(0, n - 1), range);
    }

    public static <T> ObjectBuf<T>[] colSliceBuffers(T[][] TArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ObjectBuf[] objectBufArray = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            objectBufArray[i] = ObjectBuf.colSliceBuffer(TArray, rangeArray[i]);
        }
        return objectBufArray;
    }

    public static <T> ObjectBuf<T> patchBuffer(T[][] TArray, Range range, Range range2) {
        if (TArray == null) {
            throw new NullPointerException("ObjectBuf.patchBuffer(): theMatrix is null");
        }
        int n = Arrays.rowLength(TArray);
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ObjectBuf.patchBuffer(): theMatrix row index range = 0.." + (n - 1) + ", theRowRange = " + range);
        }
        int n2 = Arrays.colLength(TArray, range.lb());
        if (0 > range2.lb() || range2.ub() >= n2) {
            throw new IndexOutOfBoundsException("ObjectBuf.patchBuffer(): theMatrix column index range = 0.." + (n2 - 1) + ", theColRange = " + range2);
        }
        if (range.stride() == 1 && range2.stride() == 1) {
            return new ObjectMatrixBuf_1<T>(TArray, range, range2);
        }
        return new ObjectMatrixBuf<T>(TArray, range, range2);
    }

    public static <T> ObjectBuf<T>[] patchBuffers(T[][] TArray, Range[] rangeArray, Range[] rangeArray2) {
        int n = rangeArray.length;
        int n2 = rangeArray2.length;
        ObjectBuf[] objectBufArray = new ObjectBuf[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            Range range = rangeArray[i];
            for (int j = 0; j < n2; ++j) {
                objectBufArray[n3++] = ObjectBuf.patchBuffer(TArray, range, rangeArray2[j]);
            }
        }
        return objectBufArray;
    }

    public static <T> ObjectItemBuf<T[][]> objectBuffer(T[][] TArray) {
        return new ObjectItemBuf<T[][]>(TArray);
    }

    public static <T> ObjectBuf<T> buffer(SharedObject<T> sharedObject) {
        if (sharedObject == null) {
            throw new NullPointerException("ObjectBuf.buffer(): item is null");
        }
        return new SharedObjectBuf<T>(sharedObject);
    }

    public static <T> ObjectBuf<T> buffer(SharedObjectArray<T> sharedObjectArray) {
        if (sharedObjectArray == null) {
            throw new NullPointerException("ObjectBuf.buffer(): theArray is null");
        }
        int n = sharedObjectArray.length();
        return new SharedObjectArrayBuf_1<T>(sharedObjectArray, new Range(0, n - 1));
    }

    public static <T> ObjectBuf<T> sliceBuffer(SharedObjectArray<T> sharedObjectArray, Range range) {
        if (sharedObjectArray == null) {
            throw new NullPointerException("ObjectBuf.sliceBuffer(): theArray is null");
        }
        int n = sharedObjectArray.length();
        if (0 > range.lb() || range.ub() >= n) {
            throw new IndexOutOfBoundsException("ObjectBuf.sliceBuffer(): theArray index range = 0.." + (n - 1) + ", theRange = " + range);
        }
        if (range.stride() == 1) {
            return new SharedObjectArrayBuf_1<T>(sharedObjectArray, range);
        }
        return new SharedObjectArrayBuf<T>(sharedObjectArray, range);
    }

    public static <T> ObjectBuf<T>[] sliceBuffers(SharedObjectArray<T> sharedObjectArray, Range[] rangeArray) {
        int n = rangeArray.length;
        ObjectBuf[] objectBufArray = new ObjectBuf[n];
        for (int i = 0; i < n; ++i) {
            objectBufArray[i] = ObjectBuf.sliceBuffer(sharedObjectArray, rangeArray[i]);
        }
        return objectBufArray;
    }

    public abstract T get(int var1);

    public abstract void put(int var1, T var2);

    @Override
    public void copy(Buf buf) {
        if (buf != this) {
            ObjectBuf.defaultCopy((ObjectBuf)buf, this);
            this.reset();
        }
    }

    @Override
    public void fill(Object object) {
        Object object2 = object;
        for (int i = 0; i < this.myLength; ++i) {
            this.put(i, object2);
        }
        this.reset();
    }

    @Override
    public Buf getTemporaryBuf() {
        return ObjectBuf.buffer(new Object[this.myLength]);
    }

    public void reset() {
        this.mySerializedItems = null;
    }

    @Override
    void preSend() throws IOException {
        if (this.mySerializedItems == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeInt(this.myLength);
            for (int i = 0; i < this.myLength; ++i) {
                objectOutputStream.writeObject(this.get(i));
            }
            objectOutputStream.close();
            this.mySerializedItems = byteArrayOutputStream.toByteArray();
            this.myMessageLength = this.mySerializedItems.length;
        }
    }

    @Override
    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(this.myMessageLength - n, byteBuffer.remaining());
        byteBuffer.put(this.mySerializedItems, n, n2);
        return n2;
    }

    @Override
    void preReceive(int n) {
        this.mySerializedItems = new byte[n];
        this.myMessageLength = n;
    }

    @Override
    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n2;
        n3 = Math.min(n3, this.myMessageLength - n);
        n3 = Math.min(n3, byteBuffer.remaining());
        byteBuffer.get(this.mySerializedItems, n, n3);
        return n3;
    }

    @Override
    int skipItems(int n, ByteBuffer byteBuffer) {
        int n2 = Math.min(n, byteBuffer.remaining());
        byteBuffer.position(byteBuffer.position() + n2);
        return n2;
    }

    @Override
    void postReceive(Status status, ClassLoader classLoader) throws IOException {
        try {
            byte[] byArray = this.mySerializedItems;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mySerializedItems);
            MPObjectInputStream mPObjectInputStream = new MPObjectInputStream(byteArrayInputStream, classLoader);
            int n = mPObjectInputStream.readInt();
            int n2 = Math.min(this.myLength, n);
            for (int i = 0; i < n2; ++i) {
                this.put(i, mPObjectInputStream.readObject());
            }
            mPObjectInputStream.close();
            status.length = n;
            this.mySerializedItems = byArray;
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException("ObjectBuf.postReceive(): Class not found");
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
        catch (ClassCastException classCastException) {
            IOException iOException = new IOException("ObjectBuf.postReceive(): Wrong type");
            iOException.initCause(classCastException);
            throw iOException;
        }
    }

    protected static <T> void defaultCopy(ObjectBuf<T> objectBuf, ObjectBuf<T> objectBuf2) {
        int n = Math.min(objectBuf.myLength, objectBuf2.myLength);
        for (int i = 0; i < n; ++i) {
            objectBuf2.put(i, objectBuf.get(i));
        }
    }
}

