/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineBufferedOutputStream
extends FilterOutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public LineBufferedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.buffer.write(n);
        if (n == 10) {
            this.flushBuffer();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n2 > 0) {
            int n3 = this.findNewlineIndex(byArray, n, n2);
            if (n3 == n + n2) {
                this.buffer.write(byArray, n, n2);
                n += n2;
                n2 = 0;
                continue;
            }
            int n4 = n3 - n + 1;
            this.buffer.write(byArray, n, n4);
            this.flushBuffer();
            n += n4;
            n2 -= n4;
        }
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flushBuffer();
            this.out.close();
        }
        finally {
            this.buffer = null;
            this.out = null;
        }
    }

    private void flushBuffer() throws IOException {
        this.buffer.writeTo(this.out);
        this.buffer.reset();
    }

    private int findNewlineIndex(byte[] byArray, int n, int n2) {
        while (n2 > 0 && byArray[n] != 10) {
            ++n;
            --n2;
        }
        return n;
    }
}

