/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.GrayBufferedImage;
import edu.rit.image.GrayDisplayable;
import edu.rit.image.InputBitStream;
import edu.rit.image.OutputBitStream;
import edu.rit.image.PJGImage;
import edu.rit.image.PJGImageFileFormatException;
import edu.rit.swing.Displayable;
import edu.rit.util.Range;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class PJGGrayImage
extends PJGImage {
    public static final Interpretation ZERO_IS_WHITE = Interpretation.ZERO_IS_WHITE;
    public static final Interpretation ZERO_IS_BLACK = Interpretation.ZERO_IS_BLACK;
    static final Transformation ZERO_IS_WHITE_TRANSFORMATION = new Transformation(){

        public byte transformInt(int n) {
            return (byte)(255 - Math.max(0, Math.min(n, 255)));
        }

        public byte transformFloat(float f) {
            return (byte)(255 - Math.max(0, Math.min((int)(f * 256.0f), 255)));
        }

        public int inverseTransformInt(byte by) {
            return 255 - (by & 0xFF);
        }

        public float inverseTransformFloat(byte by) {
            return (float)(255 - (by & 0xFF)) / 256.0f;
        }
    };
    static final Transformation ZERO_IS_BLACK_TRANSFORMATION = new Transformation(){

        public byte transformInt(int n) {
            return (byte)Math.max(0, Math.min(n, 255));
        }

        public byte transformFloat(float f) {
            return (byte)Math.max(0, Math.min((int)(f * 256.0f), 255));
        }

        public int inverseTransformInt(byte by) {
            return by & 0xFF;
        }

        public float inverseTransformFloat(byte by) {
            return (float)(by & 0xFF) / 256.0f;
        }
    };
    byte[][] myMatrix;
    Transformation myTransformation = ZERO_IS_BLACK_TRANSFORMATION;

    public PJGGrayImage() {
        super(1);
    }

    public PJGGrayImage(int n, int n2, byte[][] byArray) {
        super(1);
        this.setMatrix(n, n2, byArray);
    }

    public byte[][] getMatrix() {
        return this.myMatrix;
    }

    public void setMatrix(int n, int n2, byte[][] byArray) {
        this.setHeightAndWidth(n, n2);
        if (byArray.length != this.myHeight) {
            throw new IllegalArgumentException("PJGGrayImage.setMatrix(): theMatrix.length (= " + byArray.length + ") does not equal image height (= " + this.myHeight + ")");
        }
        this.myMatrix = byArray;
    }

    public Interpretation getInterpretation() {
        if (this.myTransformation == ZERO_IS_WHITE_TRANSFORMATION) {
            return ZERO_IS_WHITE;
        }
        return ZERO_IS_BLACK;
    }

    public void setInterpretation(Interpretation interpretation) {
        switch (interpretation) {
            case ZERO_IS_WHITE: {
                this.myTransformation = ZERO_IS_WHITE_TRANSFORMATION;
                break;
            }
            case ZERO_IS_BLACK: {
                this.myTransformation = ZERO_IS_BLACK_TRANSFORMATION;
            }
        }
    }

    public int getIntPixel(int n, int n2) {
        return this.myTransformation.inverseTransformInt(this.myMatrix[n][n2]);
    }

    public float getPixel(int n, int n2) {
        return this.myTransformation.inverseTransformFloat(this.myMatrix[n][n2]);
    }

    public void setIntPixel(int n, int n2, int n3) {
        this.myMatrix[n][n2] = this.myTransformation.transformInt(n3);
    }

    public void setPixel(int n, int n2, float f) {
        this.myMatrix[n][n2] = this.myTransformation.transformFloat(f);
    }

    public void fill(int n) {
        byte by = this.myTransformation.transformInt(n);
        for (int i = 0; i < this.myHeight; ++i) {
            Arrays.fill(this.myMatrix[i], by);
        }
    }

    public void fill(float f) {
        byte by = this.myTransformation.transformFloat(f);
        for (int i = 0; i < this.myHeight; ++i) {
            Arrays.fill(this.myMatrix[i], by);
        }
    }

    public PJGImage.Writer prepareToWrite(OutputStream outputStream) throws IOException {
        return new GrayWriter(outputStream);
    }

    public PJGImage.Reader prepareToRead(InputStream inputStream) throws IOException {
        return new GrayReader(inputStream);
    }

    public BufferedImage getBufferedImage() {
        return new GrayBufferedImage(this.myHeight, this.myWidth, this.myMatrix);
    }

    public Displayable getDisplayable() {
        return new GrayDisplayable(this.myHeight, this.myWidth, this.myMatrix);
    }

    private void writePixelData(DataOutputStream dataOutputStream, int n, int n2, int n3, int n4) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        OutputBitStream outputBitStream = new OutputBitStream(dataOutputStream);
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = n; i < n5; ++i) {
            byte[] byArray = this.myMatrix[i];
            int n7 = 0;
            for (int j = n2; j < n6; ++j) {
                int n8 = byArray[j] & 0xFF;
                int n9 = n8 - n7;
                n7 = n8;
                if (n9 < -42 || n9 > 42) {
                    outputBitStream.writeBits(0xF00 | n8, 12);
                    continue;
                }
                if (n9 < -10) {
                    outputBitStream.writeBits(0x380 | n9 + 10 & 0x3F, 10);
                    continue;
                }
                if (n9 > 10) {
                    outputBitStream.writeBits(0x380 | n9 - 11 & 0x3F, 10);
                    continue;
                }
                if (n9 < -2) {
                    outputBitStream.writeBits(0x60 | n9 + 2 & 0xF, 7);
                    continue;
                }
                if (n9 > 2) {
                    outputBitStream.writeBits(0x60 | n9 - 3 & 0xF, 7);
                    continue;
                }
                if (n9 < 0) {
                    outputBitStream.writeBits(8 | n9 & 3, 4);
                    continue;
                }
                if (n9 > 0) {
                    outputBitStream.writeBits(8 | n9 - 1 & 3, 4);
                    continue;
                }
                outputBitStream.writeBits(0, 1);
            }
        }
        outputBitStream.flush();
    }

    private void readPixelData(DataInputStream dataInputStream, int n, int n2, int n3, int n4) throws IOException {
        if (this.myMatrix == null) {
            this.myMatrix = new byte[this.myHeight][];
        }
        InputBitStream inputBitStream = new InputBitStream(dataInputStream);
        int n5 = n + n3;
        int n6 = n2 + n4;
        for (int i = n; i < n5; ++i) {
            byte[] byArray = this.myMatrix[i];
            if (byArray == null) {
                byArray = new byte[n6];
                this.myMatrix[i] = byArray;
            } else if (byArray.length < n6) {
                byte[] byArray2 = new byte[n6];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
                this.myMatrix[i] = byArray2;
            }
            int n7 = 0;
            for (int j = n2; j < n6; ++j) {
                int n8;
                int n9;
                if (inputBitStream.peekBits(1) == 0) {
                    inputBitStream.skipBits(1);
                    n9 = n7;
                } else if (inputBitStream.peekBits(2) == 2) {
                    inputBitStream.skipBits(2);
                    n8 = inputBitStream.readBits(2);
                    n8 = (n8 & 2) != 0 ? (n8 |= 0xFFFFFFFC) : ++n8;
                    n9 = n7 + n8;
                } else if (inputBitStream.peekBits(3) == 6) {
                    inputBitStream.skipBits(3);
                    n8 = inputBitStream.readBits(4);
                    n8 = (n8 & 8) != 0 ? (n8 | 0xFFFFFFF0) - 2 : (n8 += 3);
                    n9 = n7 + n8;
                } else if (inputBitStream.peekBits(4) == 14) {
                    inputBitStream.skipBits(4);
                    n8 = inputBitStream.readBits(6);
                    n8 = (n8 & 0x20) != 0 ? (n8 | 0xFFFFFFC0) - 10 : (n8 += 11);
                    n9 = n7 + n8;
                } else {
                    inputBitStream.skipBits(4);
                    n9 = inputBitStream.readBits(8);
                }
                byArray[j] = (byte)n9;
                n7 = n9;
            }
        }
    }

    private class GrayReader
    extends PJGImage.Reader {
        int myRow;
        int myCol;
        int myRowLen;
        int myColLen;

        GrayReader(InputStream inputStream) throws IOException {
            super(inputStream);
            this.getPixelDataSegmentParameters();
        }

        public void read() throws IOException {
            while (this.myNextSegmentType != -1) {
                this.readSegment();
            }
        }

        public Range getRowRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myRow, this.myRow + this.myRowLen - 1);
        }

        public Range getColRange() {
            return this.myNextSegmentType == -1 ? null : new Range(this.myCol, this.myCol + this.myColLen - 1);
        }

        public void readSegment() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            PJGGrayImage.this.readPixelData(this.myDis, this.myRow, this.myCol, this.myRowLen, this.myColLen);
            this.myNextSegmentType = this.myDis.read();
            this.getPixelDataSegmentParameters();
        }

        private void getPixelDataSegmentParameters() throws IOException {
            if (this.myNextSegmentType == -1) {
                return;
            }
            if (this.myNextSegmentType != 7) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment type (= " + this.myNextSegmentType + ")");
            }
            this.myRow = this.myDis.readInt();
            if (0 > this.myRow || this.myRow >= PJGGrayImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row index (= " + this.myRow + ")");
            }
            this.myCol = this.myDis.readInt();
            if (0 > this.myCol || this.myCol >= PJGGrayImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column index (= " + this.myCol + ")");
            }
            this.myRowLen = this.myDis.readInt();
            if (1 > this.myRowLen || this.myRow + this.myRowLen > PJGGrayImage.this.myHeight) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment row count (= " + this.myRowLen + ")");
            }
            this.myColLen = this.myDis.readInt();
            if (1 > this.myColLen || this.myCol + this.myColLen > PJGGrayImage.this.myWidth) {
                throw new PJGImageFileFormatException("Invalid PJG pixel data segment column count (= " + this.myColLen + ")");
            }
        }
    }

    private class GrayWriter
    extends PJGImage.Writer {
        private GrayWriter(OutputStream outputStream) throws IOException {
            super(outputStream);
        }

        public void write() throws IOException {
            PJGGrayImage.this.writePixelData(this.myDos, 0, 0, PJGGrayImage.this.myHeight, PJGGrayImage.this.myWidth);
        }

        public void writeRowSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGGrayImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeRowSlice(): Image row range = 0.." + (PJGGrayImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeRowSlice(): theRowRange stride = " + n4 + " illegal");
            }
            PJGGrayImage.this.writePixelData(this.myDos, n, 0, n3, PJGGrayImage.this.myWidth);
        }

        public void writeColSlice(Range range) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGGrayImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writeColSlice(): Image column range = 0.." + (PJGGrayImage.this.myWidth - 1) + ", theColRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writeColSlice(): theColRange stride = " + n4 + " illegal");
            }
            PJGGrayImage.this.writePixelData(this.myDos, 0, n, PJGGrayImage.this.myHeight, n3);
        }

        public void writePatch(Range range, Range range2) throws IOException {
            int n = range.lb();
            int n2 = range.ub();
            int n3 = range.length();
            int n4 = range.stride();
            if (0 > n || n2 >= PJGGrayImage.this.myHeight) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image row range = 0.." + (PJGGrayImage.this.myHeight - 1) + ", theRowRange = " + range);
            }
            if (n4 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theRowRange stride = " + n4 + " illegal");
            }
            int n5 = range2.lb();
            int n6 = range2.ub();
            int n7 = range2.length();
            int n8 = range2.stride();
            if (0 > n5 || n6 >= PJGGrayImage.this.myWidth) {
                throw new IndexOutOfBoundsException("PJGImage.Writer.writePatch(): Image column range = 0.." + (PJGGrayImage.this.myWidth - 1) + ", theColRange = " + range2);
            }
            if (n8 > 1) {
                throw new IllegalArgumentException("PJGImage.Writer.writePatch(): theColRange stride = " + n8 + " illegal");
            }
            PJGGrayImage.this.writePixelData(this.myDos, n, n5, n3, n7);
        }
    }

    static interface Transformation {
        public byte transformInt(int var1);

        public byte transformFloat(float var1);

        public int inverseTransformInt(byte var1);

        public float inverseTransformFloat(byte var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Interpretation {
        ZERO_IS_WHITE,
        ZERO_IS_BLACK;

    }
}

