/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.antimatter;

import edu.rit.pj.Comm;
import edu.rit.util.Random;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class RenderSeq {
    private static final double DIAM = 2.0;
    private static final double DIAM_OVER_2 = 1.0;
    private static final Color BACKGROUND_COLOR = Color.black;
    private static final Color ANTIPROTON_COLOR = Color.red;
    static long seed;
    static int N;
    static int W;
    static int F;
    static String file;
    static Random prng;
    static Ellipse2D dot;
    static IndexColorModel colormodel;
    static BufferedImage image;
    static Graphics2D g2d;
    static StringBuilder filename;

    private RenderSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        long l = System.currentTimeMillis();
        if (stringArray.length != 5) {
            RenderSeq.usage();
        }
        seed = Long.parseLong(stringArray[0]);
        N = Integer.parseInt(stringArray[1]);
        W = Integer.parseInt(stringArray[2]);
        F = Integer.parseInt(stringArray[3]);
        file = stringArray[4];
        prng = Random.getInstance(seed);
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        for (n = 0; n < 256; ++n) {
            byArray[n] = (byte)n;
        }
        colormodel = new IndexColorModel(8, 256, byArray, byArray2, byArray3);
        image = new BufferedImage(W, W, 13, colormodel);
        g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        for (n = 0; n < F; ++n) {
            g2d.setColor(BACKGROUND_COLOR);
            g2d.fillRect(0, 0, W, W);
            g2d.setColor(ANTIPROTON_COLOR);
            for (int i = 0; i < N; ++i) {
                dot.setFrame((double)W * prng.nextDouble() - 1.0, (double)W * prng.nextDouble() - 1.0, 2.0, 2.0);
                g2d.fill(dot);
            }
            filename.setLength(0);
            filename.append(n);
            while (filename.length() < 4) {
                filename.insert(0, '0');
            }
            filename.insert(0, '_');
            filename.insert(0, file);
            filename.append(".png");
            ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename.toString())));
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.hyb.antimatter.RenderSeq <seed> <N> <W> <F> <file>");
        System.err.println("<seed> = Random seed");
        System.err.println("<N> = Number of antiprotons");
        System.err.println("<W> = Image is <W>x<W> pixels");
        System.err.println("<F> = Number of frames (files)");
        System.err.println("<file> = Files are named \"<file>_0000.png\", \"<file>_0001.png\", etc.");
        System.exit(1);
    }

    static {
        dot = new Ellipse2D.Double();
        filename = new StringBuilder();
    }
}

