/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import edu.rit.util.Logger;
import edu.rit.util.PrintStreamLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class HttpServer {
    private ServerSocket myServerSocket;
    private AcceptorThread myAcceptorThread;
    private Logger myLogger;

    public HttpServer(InetSocketAddress inetSocketAddress) throws IOException {
        this(inetSocketAddress, null);
    }

    public HttpServer(InetSocketAddress inetSocketAddress, Logger logger) throws IOException {
        this.myLogger = logger == null ? new PrintStreamLogger() : logger;
        this.myServerSocket = new ServerSocket();
        this.myServerSocket.bind(inetSocketAddress);
        this.myAcceptorThread = new AcceptorThread();
        this.myAcceptorThread.setDaemon(true);
        this.myAcceptorThread.start();
    }

    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.myServerSocket.getLocalSocketAddress();
    }

    public void close() throws IOException {
        this.myServerSocket.close();
    }

    protected abstract void process(HttpRequest var1, HttpResponse var2) throws IOException;

    private class AcceptorThread
    extends Thread {
        private AcceptorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                try {
                    while (true) {
                        Socket socket = HttpServer.this.myServerSocket.accept();
                        socket.setSoTimeout(2000);
                        HttpRequest httpRequest = new HttpRequest(socket);
                        HttpResponse httpResponse = new HttpResponse(socket);
                        try {
                            HttpServer.this.process(httpRequest, httpResponse);
                        }
                        catch (Throwable throwable) {
                            HttpServer.this.myLogger.log("Exception while processing HTTP request", throwable);
                        }
                        finally {
                            try {
                                if (!socket.isClosed()) {
                                    socket.close();
                                }
                            }
                            catch (Throwable throwable) {
                                HttpServer.this.myLogger.log("Exception while closing HTTP socket", throwable);
                            }
                        }
                        socket = null;
                        httpRequest = null;
                        httpResponse = null;
                    }
                }
                catch (Throwable throwable) {
                    if (!HttpServer.this.myServerSocket.isClosed()) {
                        HttpServer.this.myLogger.log("Exception while accepting HTTP connection", throwable);
                    }
                    HttpServer.this.myLogger.log("HTTP server terminating");
                }
            }
            catch (Throwable throwable) {
                HttpServer.this.myLogger.log("HTTP server terminating");
                throw throwable;
            }
        }
    }
}

