/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.http;

import java.io.IOException;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest {
    public static final String GET_METHOD = "GET";
    public static final String HEAD_METHOD = "HEAD";
    public static final String POST_METHOD = "POST";
    public static final String HTTP_1_0_VERSION = "HTTP/1.0";
    public static final String HTTP_1_1_VERSION = "HTTP/1.1";
    private Socket mySocket;
    private String myMethod;
    private String myUri;
    private String myHttpVersion;
    private Map<String, String> myHeaderMap = new HashMap<String, String>();
    private Map<String, String> myUnmodifiableHeaderMap = Collections.unmodifiableMap(this.myHeaderMap);
    private boolean iamValid;

    public HttpRequest(Socket socket) {
        if (socket == null) {
            throw new NullPointerException("HttpRequest(): theSocket is null");
        }
        this.mySocket = socket;
    }

    public boolean isValid() {
        this.parse();
        return this.iamValid;
    }

    public String getMethod() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myMethod;
    }

    public String getUri() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myUri;
    }

    public String getHttpVersion() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myHttpVersion;
    }

    public String getHeader(String string) {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myHeaderMap.get(string);
    }

    public Collection<Map.Entry<String, String>> getHeaders() {
        if (!this.isValid()) {
            throw new IllegalStateException("HTTP request is invalid");
        }
        return this.myUnmodifiableHeaderMap.entrySet();
    }

    private void parse() {
        if (this.myMethod != null) {
            return;
        }
        this.iamValid = false;
        this.myMethod = "";
        this.myUri = "";
        this.myHttpVersion = "";
        try {
            Scanner scanner = new Scanner(this.mySocket.getInputStream());
            if (!scanner.hasNextLine()) {
                return;
            }
            String string = scanner.nextLine();
            Scanner scanner2 = new Scanner(string);
            if (!scanner2.hasNext()) {
                return;
            }
            String string2 = scanner2.next();
            if (!scanner2.hasNext()) {
                return;
            }
            String string3 = scanner2.next();
            if (!scanner2.hasNext()) {
                return;
            }
            String string4 = scanner2.next();
            if (scanner2.hasNext()) {
                return;
            }
            String string5 = null;
            String string6 = "";
            while (true) {
                int n;
                if (!scanner.hasNextLine()) {
                    return;
                }
                string = scanner.nextLine();
                if (string.length() == 0) break;
                if (Character.isWhitespace(string.charAt(0))) {
                    if (string5 == null) {
                        return;
                    }
                    string6 = string6 + string;
                    continue;
                }
                if (string5 != null) {
                    this.myHeaderMap.put(string5, string6);
                    string5 = null;
                    string6 = "";
                }
                if ((n = string.indexOf(58)) <= 0) {
                    return;
                }
                if (n >= string.length() - 1) {
                    return;
                }
                if (!Character.isWhitespace(string.charAt(n + 1))) {
                    return;
                }
                string5 = string.substring(0, n);
                string6 = string6 + string.substring(n + 2);
            }
            if (string5 != null) {
                this.myHeaderMap.put(string5, string6);
            }
            this.myMethod = string2;
            this.myUri = string3;
            this.myHttpVersion = string4;
            this.iamValid = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

