/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Fill;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.ShapeItem;
import edu.rit.draw.item.Size;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;

public class Polygon
extends ShapeItem {
    private static final long serialVersionUID = -8680229678155189048L;
    LinkedList<Point> myPoints = new LinkedList();
    Point myLastPoint;
    Point myNw;
    Point mySe;
    Size mySize;

    public Polygon() {
    }

    public Polygon(Polygon polygon) {
        super(polygon);
        this.myPoints.clear();
        this.myPoints.addAll(polygon.myPoints);
        if (!this.myPoints.isEmpty()) {
            this.myLastPoint = this.myPoints.get(this.myPoints.size() - 1);
        }
    }

    public Size size() {
        this.computeBoundingBox();
        return this.mySize;
    }

    public double width() {
        this.computeBoundingBox();
        return this.mySize.width;
    }

    public double height() {
        this.computeBoundingBox();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeBoundingBox();
        return this.myNw;
    }

    public Polygon outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Polygon fill(Fill fill) {
        this.doFill(fill);
        return this;
    }

    public Polygon clear() {
        this.myPoints.clear();
        this.myLastPoint = null;
        this.myNw = null;
        return this;
    }

    public Polygon to(double d, double d2) {
        return this.addEndpoint(new Point(d, d2));
    }

    public Polygon to(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        return this.addEndpoint(point);
    }

    public Polygon hto(double d) {
        return this.addEndpoint(new Point(d, this.myLastPoint.y));
    }

    public Polygon hto(Point point) {
        return this.addEndpoint(new Point(point.x, this.myLastPoint.y));
    }

    public Polygon vto(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x, d));
    }

    public Polygon vto(Point point) {
        return this.addEndpoint(new Point(this.myLastPoint.x, point.y));
    }

    public Polygon by(double d, double d2) {
        return this.addEndpoint(new Point(this.myLastPoint.x + d, this.myLastPoint.y + d2));
    }

    public Polygon by(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x + size.width, this.myLastPoint.y + size.height));
    }

    public Polygon hby(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x + d, this.myLastPoint.y));
    }

    public Polygon hby(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x + size.width, this.myLastPoint.y));
    }

    public Polygon vby(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x, this.myLastPoint.y + d));
    }

    public Polygon vby(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x, this.myLastPoint.y + size.height));
    }

    public Polygon add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Polygon add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Polygon addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Polygon addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.myPoints.size());
        for (Point point : this.myPoints) {
            objectOutput.writeObject(point);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.myPoints.clear();
        for (int i = 0; i < n; ++i) {
            this.myPoints.add((Point)objectInput.readObject());
        }
        if (!this.myPoints.isEmpty()) {
            this.myLastPoint = this.myPoints.get(this.myPoints.size() - 1);
        }
        this.myNw = null;
        this.mySe = null;
        this.mySize = null;
    }

    private Polygon addEndpoint(Point point) {
        this.myLastPoint = point;
        this.myPoints.add(point);
        this.myNw = null;
        return this;
    }

    private void computeBoundingBox() {
        if (this.myNw == null) {
            this.myNw = new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.mySe = new Point(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            for (Point point : this.myPoints) {
                this.myNw = this.myNw.min(point);
                this.mySe = this.mySe.max(point);
            }
            this.mySize = this.mySe.difference(this.myNw);
        }
    }

    Shape getShape() {
        GeneralPath generalPath = new GeneralPath();
        int n = this.myPoints.size();
        Iterator iterator = this.myPoints.iterator();
        Point point = null;
        if (n > 0) {
            point = (Point)iterator.next();
            generalPath.moveTo((float)point.x, (float)point.y);
            while (iterator.hasNext()) {
                point = (Point)iterator.next();
                generalPath.lineTo((float)point.x, (float)point.y);
            }
            generalPath.closePath();
        }
        return generalPath;
    }
}

