/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.clu.network;

import edu.rit.io.DoubleMatrixFile;
import edu.rit.pj.Comm;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FloydSeq {
    static int n;
    static double[][] d;

    private FloydSeq() {
    }

    public static void main(String[] stringArray) throws Throwable {
        Object object;
        long l = System.currentTimeMillis();
        Comm.init(stringArray);
        if (stringArray.length != 2) {
            FloydSeq.usage();
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        DoubleMatrixFile doubleMatrixFile = new DoubleMatrixFile();
        DoubleMatrixFile.Reader reader = doubleMatrixFile.prepareToRead(new BufferedInputStream(new FileInputStream(file)));
        reader.read();
        reader.close();
        d = doubleMatrixFile.getMatrix();
        n = d.length;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            double[] dArray = d[i];
            for (int j = 0; j < n; ++j) {
                object = d[j];
                for (int k = 0; k < n; ++k) {
                    object[k] = Math.min((double)object[k], (double)(object[i] + dArray[k]));
                }
            }
        }
        long l3 = System.currentTimeMillis();
        DoubleMatrixFile doubleMatrixFile2 = new DoubleMatrixFile(n, n, d);
        object = doubleMatrixFile2.prepareToWrite(new BufferedOutputStream(new FileOutputStream(file2)));
        ((DoubleMatrixFile.Writer)object).write();
        ((DoubleMatrixFile.Writer)object).close();
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.clu.network.FloydSeq <infile> <outfile>");
        System.err.println("<infile> = Input distance matrix file");
        System.err.println("<outfile> = Output distance matrix file");
        System.exit(1);
    }
}

