## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(mc.cores=2)

## ----echo=FALSE, eval=TRUE, results='hide'------------------------------------
library(SingleCellSignalR)
data(example_dataset, package = "SingleCellSignalR")
data = example_dataset
genes = data$genes
rownames(data) = genes
data = data[,-1]

## ----echo=TRUE, eval=FALSE----------------------------------------------------
# clust <- clustering(data = data, n.cluster = 4, n = 10, method = "simlr",write = FALSE,pdf=FALSE)

## ----echo=FALSE, eval=TRUE----------------------------------------------------
clust <- clustering(data = data,n.cluster = 4, n = 10, method = "kmeans",write = FALSE,pdf=FALSE)

## ----eval=TRUE, results='hide'------------------------------------------------
clust.ana <- cluster_analysis(data = data, genes = rownames(data), cluster = clust$cluster, write = FALSE)

## ----eval=TRUE----------------------------------------------------------------
signal <- cell_signaling(data = data, genes = rownames(data), cluster = clust$cluster, write = FALSE)

## ----eval=TRUE----------------------------------------------------------------
inter.net <- inter_network(data = data, signal = signal, genes = genes, cluster = clust$cluster, write = FALSE)

## ----eval=TRUE----------------------------------------------------------------
visualize_interactions(signal = signal)

## ----eval=TRUE----------------------------------------------------------------
visualize_interactions(signal = signal,show.in=c(1,4))

## ----echo=FALSE, eval=TRUE, results='hide'------------------------------------
data(example_dataset, package = "SingleCellSignalR")
data = example_dataset
genes = data$genes
rownames(data) = genes
data = data[,-1]

## ----eval=TRUE, results='hide'------------------------------------------------
class = cell_classifier(data=data, genes=rownames(data), markers = markers(c("immune")), tsne=clust$`t-SNE`,plot.details=TRUE,write = FALSE)


## ----eval=TRUE, results='hide'------------------------------------------------
# Define the cluster vector and the cluster names 
cluster <- class$cluster
c.names <- class$c.names

# Remove undefined cells 
data <- data[,cluster!=(max(cluster))]
tsne <- clust$`t-SNE`[cluster!=(max(cluster)),]
c.names <- c.names[-max(cluster)]
cluster <- cluster[cluster!=(max(cluster))]

## ----eval=TRUE----------------------------------------------------------------
clust.ana <- cluster_analysis(data = data, genes = rownames(data), cluster = cluster, c.names = c.names, write = FALSE)

## ----eval=TRUE----------------------------------------------------------------
signal <- cell_signaling(data = data, genes = genes, cluster = cluster, c.names = c.names, write = FALSE)

inter.net <- inter_network(data = data, signal = signal, genes = genes, cluster = cluster, write = FALSE)

## ----eval=TRUE----------------------------------------------------------------
signal[[6]]

## ----eval=FALSE---------------------------------------------------------------
# intra = intra_network(goi = "ASGR1",data = data,genes = rownames(data),cluster = cluster, coi = "Macrophages", c.names = c.names, signal = signal,write=FALSE)

## ----eval=TRUE----------------------------------------------------------------
visualize_interactions(signal)

## ----eval=TRUE----------------------------------------------------------------
visualize_interactions(signal, show.in=c(1,6))

