/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bridgedb.AttributeMapper;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.impl.TransitiveGraph;

public class IDMapperStack
implements IDMapper,
AttributeMapper {
    private final List<IDMapper> gdbs = new CopyOnWriteArrayList<IDMapper>();
    private TransitiveGraph transitiveGraph = null;
    private boolean isTransitive = false;
    private final IDMapperCapabilities caps = new IDMapperStackCapabilities();

    private TransitiveGraph getTransitiveGraph() throws IDMapperException {
        if (this.transitiveGraph == null) {
            this.transitiveGraph = new TransitiveGraph(this.gdbs);
        }
        return this.transitiveGraph;
    }

    public IDMapper addIDMapper(String connectionString) throws IDMapperException {
        IDMapper idMapper = BridgeDb.connect(connectionString);
        this.addIDMapper(idMapper);
        return idMapper;
    }

    public void addIDMapper(IDMapper idMapper) {
        if (idMapper != null) {
            this.gdbs.add(idMapper);
            this.transitiveGraph = null;
        }
    }

    public void setTransitive(boolean value) {
        this.isTransitive = value;
    }

    public boolean getTransitive() {
        return this.isTransitive;
    }

    public void removeIDMapper(IDMapper idMapper) {
        this.gdbs.remove(idMapper);
        this.transitiveGraph = null;
    }

    @Override
    public void close() throws IDMapperException {
        IDMapperException postponed = null;
        for (IDMapper child : this.gdbs) {
            if (child == null) continue;
            try {
                child.close();
                child = null;
            }
            catch (IDMapperException ex) {
                postponed = ex;
            }
        }
        if (postponed != null) {
            throw postponed;
        }
    }

    @Override
    public boolean xrefExists(Xref xref) throws IDMapperException {
        for (IDMapper child : this.gdbs) {
            if (child == null || !child.isConnected() || !child.xrefExists(xref)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        for (IDMapper child : this.gdbs) {
            if (child == null || !child.isConnected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDMapperCapabilities getCapabilities() {
        return this.caps;
    }

    @Override
    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        HashSet<Xref> result = new HashSet<Xref>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !child.isConnected()) continue;
            result.addAll(child.freeSearch(text, limit));
        }
        return result;
    }

    @Override
    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        if (this.isTransitive) {
            return this.mapIDtransitive(srcXrefs, tgtDataSources);
        }
        return this.mapIDnormal(srcXrefs, tgtDataSources);
    }

    private Map<Xref, Set<Xref>> mapIDnormal(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        HashMap<Xref, Set<Xref>> result = new HashMap<Xref, Set<Xref>>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !child.isConnected()) continue;
            for (Map.Entry<Xref, Set<Xref>> entry : child.mapID(srcXrefs, tgtDataSources).entrySet()) {
                HashSet resultSet = (HashSet)result.get(entry.getKey());
                if (resultSet == null) {
                    resultSet = new HashSet();
                    result.put(entry.getKey(), resultSet);
                }
                resultSet.addAll(entry.getValue());
            }
        }
        return result;
    }

    private Map<Xref, Set<Xref>> mapIDtransitive(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        HashMap<Xref, Set<Xref>> result = new HashMap<Xref, Set<Xref>>();
        for (Xref ref : srcXrefs) {
            result.put(ref, this.mapIDtransitive(ref, tgtDataSources));
        }
        return result;
    }

    @Override
    public Set<String> getAttributes(Xref ref, String attrname) throws IDMapperException {
        HashSet<String> result = new HashSet<String>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !child.isConnected()) continue;
            result.addAll(((AttributeMapper)((Object)child)).getAttributes(ref, attrname));
        }
        return result;
    }

    public Set<String> getAttributesForAllMappings(Xref ref, String attrname, DataSource ... dataSources) throws IDMapperException {
        HashSet<String> result = new HashSet<String>();
        Set<Xref> mappings = this.mapID(ref, dataSources);
        mappings.add(ref);
        for (Xref mappedRef : mappings) {
            result.addAll(this.getAttributes(mappedRef, attrname));
        }
        return result;
    }

    @Override
    public boolean isFreeAttributeSearchSupported() {
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !((AttributeMapper)((Object)child)).isFreeAttributeSearchSupported()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Xref, String> freeAttributeSearch(String query, String attrType, int limit) throws IDMapperException {
        Map<Xref, String> result = null;
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !child.isConnected() || !((AttributeMapper)((Object)child)).isFreeAttributeSearchSupported()) continue;
            Map<Xref, String> childResult = ((AttributeMapper)((Object)child)).freeAttributeSearch(query, attrType, limit);
            if (result == null) {
                result = childResult;
                continue;
            }
            for (Xref ref : childResult.keySet()) {
                if (result.containsKey(ref)) continue;
                result.put(ref, childResult.get(ref));
            }
        }
        return result;
    }

    @Override
    public Map<Xref, Set<String>> freeAttributeSearchEx(String query, String attrType, int limit) throws IDMapperException {
        Map<Xref, Set<String>> result = new HashMap<Xref, Set<String>>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !child.isConnected() || !((AttributeMapper)((Object)child)).isFreeAttributeSearchSupported()) continue;
            Map<Xref, Set<String>> childResult = ((AttributeMapper)((Object)child)).freeAttributeSearchEx(query, attrType, limit);
            if (result == null) {
                result = childResult;
                continue;
            }
            for (Xref ref : childResult.keySet()) {
                if (result.containsKey(ref)) continue;
                result.put(ref, childResult.get(ref));
            }
        }
        return result;
    }

    public String toString() {
        String result = "";
        boolean first = true;
        for (IDMapper child : this.gdbs) {
            if (!first) {
                result = result + ", ";
            }
            first = false;
            result = result + child.toString();
        }
        return result;
    }

    public int getSize() {
        return this.gdbs.size();
    }

    public IDMapper getIDMapperAt(int index) {
        return this.gdbs.get(index);
    }

    @Override
    public Set<Xref> mapID(Xref ref, DataSource ... resultDs) throws IDMapperException {
        if (this.isTransitive) {
            return this.mapIDtransitive(ref, resultDs);
        }
        return this.mapIDnormal(ref, resultDs);
    }

    private Set<Xref> mapIDtransitive(Xref ref, DataSource ... resultDs) throws IDMapperException {
        if (resultDs.length == 0) {
            return this.getTransitiveGraph().mapIDtransitiveUntargetted(ref);
        }
        HashSet<DataSource> dsFilter = new HashSet<DataSource>(Arrays.asList(resultDs));
        Set<Xref> result = this.getTransitiveGraph().mapIDtransitiveTargetted(ref, dsFilter);
        return result;
    }

    private Set<Xref> mapIDnormal(Xref ref, DataSource ... resultDs) throws IDMapperException {
        HashSet<Xref> result = new HashSet<Xref>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !child.isConnected()) continue;
            result.addAll(child.mapID(ref, resultDs));
        }
        return result;
    }

    @Override
    public Set<String> getAttributeSet() throws IDMapperException {
        HashSet<String> result = new HashSet<String>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !child.isConnected()) continue;
            result.addAll(((AttributeMapper)((Object)child)).getAttributeSet());
        }
        return result;
    }

    @Override
    public Map<String, Set<String>> getAttributes(Xref ref) throws IDMapperException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (IDMapper child : this.gdbs) {
            if (child == null || !(child instanceof AttributeMapper) || !child.isConnected()) continue;
            for (Map.Entry<String, Set<String>> entry : ((AttributeMapper)((Object)child)).getAttributes(ref).entrySet()) {
                Set thisSet;
                if (!result.containsKey(entry.getKey())) {
                    thisSet = new HashSet();
                    result.put(entry.getKey(), thisSet);
                } else {
                    thisSet = (Set)result.get(entry.getKey());
                }
                thisSet.addAll(entry.getValue());
            }
        }
        return result;
    }

    public Map<String, Set<String>> getAttributesForAllMappings(Xref ref, DataSource ... dataSources) throws IDMapperException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        Set<Xref> mappings = this.mapID(ref, dataSources);
        mappings.add(ref);
        for (Xref mappedRef : mappings) {
            result.putAll(this.getAttributes(mappedRef));
        }
        return result;
    }

    public List<IDMapper> getMappers() {
        return this.gdbs;
    }

    private class IDMapperStackCapabilities
    implements IDMapperCapabilities {
        private IDMapperStackCapabilities() {
        }

        @Override
        public Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
            HashSet<DataSource> result = new HashSet<DataSource>();
            for (IDMapper idm : IDMapperStack.this.gdbs) {
                Set<DataSource> dss = null;
                dss = idm.getCapabilities().getSupportedSrcDataSources();
                if (dss == null) continue;
                result.addAll(dss);
            }
            return result;
        }

        @Override
        public Set<DataSource> getSupportedTgtDataSources() throws IDMapperException {
            HashSet<DataSource> result = new HashSet<DataSource>();
            for (IDMapper idm : IDMapperStack.this.gdbs) {
                Set<DataSource> dss = null;
                dss = idm.getCapabilities().getSupportedTgtDataSources();
                if (dss == null) continue;
                result.addAll(dss);
            }
            return result;
        }

        @Override
        public boolean isMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
            if (IDMapperStack.this.isTransitive) {
                return IDMapperStack.this.getTransitiveGraph().isTransitiveMappingSupported(src, tgt);
            }
            for (IDMapper idm : IDMapperStack.this.gdbs) {
                if (!idm.getCapabilities().isMappingSupported(src, tgt)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isFreeSearchSupported() {
            for (IDMapper idm : IDMapperStack.this.gdbs) {
                if (!idm.getCapabilities().isFreeSearchSupported()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<String> getKeys() {
            return Collections.emptySet();
        }

        @Override
        public String getProperty(String key) {
            return null;
        }
    }
}

