/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.HashMap;
import java.util.Map;
import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class CachingKernel
extends NestedKernel {
    private transient Map cache;

    public CachingKernel() {
    }

    public CachingKernel(SVMKernel sVMKernel) {
        super(sVMKernel);
    }

    public double evaluate(Object object, Object object2) {
        ObjectPair objectPair = new ObjectPair(object, object2);
        Double d = null;
        Map map = this.cache;
        synchronized (map) {
            d = (Double)this.cache.get(objectPair);
        }
        if (d == null) {
            d = new Double(this.getNestedKernel().evaluate(object, object2));
            map = this.cache;
            synchronized (map) {
                this.cache.put(objectPair, d);
            }
        }
        return d;
    }

    public void setNestedKernel(SVMKernel sVMKernel) {
        super.setNestedKernel(sVMKernel);
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        this.cache.clear();
    }

    public String toString() {
        return this.getNestedKernel().toString();
    }

    private static class ObjectPair {
        Object a;
        Object b;

        public ObjectPair(Object object, Object object2) {
            this.a = object;
            this.b = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ObjectPair)) {
                return false;
            }
            ObjectPair objectPair = (ObjectPair)object;
            return objectPair.a == this.a && objectPair.b == this.b || objectPair.a == this.b && objectPair.b == this.a;
        }

        public int hashCode() {
            return this.a.hashCode() + this.b.hashCode();
        }
    }
}

