/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bridge.Biocorba.Seqcore;

import org.Biocorba.Seqcore.OutOfRange;
import org.Biocorba.Seqcore.RequestTooLarge;
import org.Biocorba.Seqcore.SeqType;
import org.Biocorba.Seqcore._AnonymousSeq_Operations;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bridge.GNOME.UnknownImpl;
import org.omg.CORBA.portable.ObjectImpl;

public class AnonymousSeqImpl
extends UnknownImpl
implements _AnonymousSeq_Operations {
    private SymbolList symList;
    private SeqType seqType;

    public AnonymousSeqImpl(SymbolList symbolList) throws IllegalAlphabetException {
        String string = symbolList.getAlphabet().getName();
        this.seqType = null;
        if (string.startsWith("DNA")) {
            this.seqType = SeqType.DNA;
        } else if (string.startsWith("RNA")) {
            this.seqType = SeqType.RNA;
        } else if (string.startsWith("PROTEIN")) {
            this.seqType = SeqType.PROTEIN;
        } else {
            throw new IllegalAlphabetException("Can only serve DNA, RNA or PROTEIN");
        }
        this.symList = symbolList;
    }

    public SymbolList getSymbolList() {
        return this.symList;
    }

    public String get_seq(ObjectImpl objectImpl) throws RequestTooLarge {
        return this.getSymbolList().seqString();
    }

    public String get_subseq(ObjectImpl objectImpl, int n, int n2) throws OutOfRange, RequestTooLarge {
        try {
            return this.getSymbolList().subStr(n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OutOfRange(indexOutOfBoundsException.toString());
        }
    }

    public int length(ObjectImpl objectImpl) {
        return this.getSymbolList().length();
    }

    public int max_request_length(ObjectImpl objectImpl) {
        return Integer.MAX_VALUE;
    }

    public SeqType type(ObjectImpl objectImpl) {
        return this.seqType;
    }
}

