/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractAlphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.SingletonList;

public class SingletonAlphabet
extends AbstractAlphabet
implements FiniteAlphabet,
Serializable {
    private final AtomicSymbol sym;
    private List alphabets;

    public SingletonAlphabet(AtomicSymbol atomicSymbol) {
        this.sym = atomicSymbol;
    }

    public void addSymbolImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't add symbols to alphabet: " + atomicSymbol.getName() + " in " + this.getName());
    }

    protected boolean containsImpl(AtomicSymbol atomicSymbol) {
        return atomicSymbol == this.sym;
    }

    public List getAlphabets() {
        if (this.alphabets == null) {
            this.alphabets = new SingletonList(this);
        }
        return this.alphabets;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public String getName() {
        return String.valueOf(this.sym.getName()) + "-alphabet";
    }

    public SymbolParser getParser(String string) throws NoSuchElementException {
        throw new NoSuchElementException("No parsers associated with " + this.getName() + ": " + string);
    }

    protected AtomicSymbol getSymbolImpl(List list) throws IllegalSymbolException {
        return (AtomicSymbol)list.get(0);
    }

    public Iterator iterator() {
        return Collections.singleton(this.sym).iterator();
    }

    public void removeSymbol(Symbol symbol) throws IllegalSymbolException {
        throw new IllegalSymbolException("Can't remove symbols from alphabet: " + symbol.getName() + " in " + this.getName());
    }

    public int size() {
        return 1;
    }

    public SymbolList symbols() {
        try {
            return new SimpleSymbolList(this, Collections.nCopies(1, this.sym));
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "This is impossible. I must contain me.");
        }
    }
}

