/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.NameParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.seq.io.TokenParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractAlphabet
implements FiniteAlphabet {
    private Map parserByName = new HashMap();
    private ChangeSupport changeSupport;

    protected AbstractAlphabet() {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.getChangeSupport(ChangeType.UNKNOWN).addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.getChangeSupport(changeType).addChangeListener(changeListener, changeType);
    }

    public final void addSymbol(Symbol symbol) throws IllegalSymbolException, ChangeVetoException {
        if (symbol == null) {
            throw new IllegalSymbolException("You can not add null as a symbol to alphabet " + this.getName());
        }
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(Alphabet.SYMBOLS);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, Alphabet.SYMBOLS, symbol, null);
                changeSupport.firePreChangeEvent(changeEvent);
                this.doAddSymbol(symbol);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.doAddSymbol(symbol);
        }
    }

    protected abstract void addSymbolImpl(AtomicSymbol var1) throws IllegalSymbolException, ChangeVetoException;

    public final boolean contains(Symbol symbol) {
        if (symbol instanceof AtomicSymbol) {
            return this.containsImpl((AtomicSymbol)symbol);
        }
        if (symbol == null) {
            throw new NullPointerException("Symbols can't be null");
        }
        Iterator iterator = ((FiniteAlphabet)symbol.getMatches()).iterator();
        while (iterator.hasNext()) {
            AtomicSymbol atomicSymbol = (AtomicSymbol)iterator.next();
            if (this.containsImpl(atomicSymbol)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean containsImpl(AtomicSymbol var1);

    private void doAddSymbol(Symbol symbol) throws IllegalSymbolException, ChangeVetoException {
        Alphabet alphabet = symbol.getMatches();
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalSymbolException("Can't add symbol " + symbol.getName() + " as it matches an infinite number of symbols.");
        }
        Iterator iterator = ((FiniteAlphabet)alphabet).iterator();
        while (iterator.hasNext()) {
            this.addSymbolImpl((AtomicSymbol)iterator.next());
        }
    }

    public abstract List getAlphabets();

    public Symbol getAmbiguity(Set set) throws IllegalSymbolException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.validate((Symbol)iterator.next());
        }
        return AlphabetManager.createSymbol('*', Annotation.EMPTY_ANNOTATION, set, (Alphabet)this);
    }

    public abstract Annotation getAnnotation();

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public abstract String getName();

    public SymbolParser getParser(String string) throws NoSuchElementException {
        SymbolParser symbolParser = (SymbolParser)this.parserByName.get(string);
        if (symbolParser == null) {
            if (string.equals("token")) {
                symbolParser = new TokenParser(this);
                this.putParser(string, symbolParser);
            } else if (string.equals("name")) {
                symbolParser = new NameParser(this);
                this.putParser(string, symbolParser);
            } else {
                throw new NoSuchElementException("There is no parser '" + string + "' defined in alphabet " + this.getName());
            }
        }
        return symbolParser;
    }

    public final Symbol getSymbol(List list) throws IllegalSymbolException {
        if (list.size() == 1) {
            Symbol symbol = (Symbol)list.get(0);
            this.validate(symbol);
            return symbol;
        }
        List list2 = this.getAlphabets();
        if (list2.size() != list.size()) {
            throw new IllegalSymbolException("Can't retrieve symbol as symbol list is the wrong length " + list.size() + ":" + list2.size());
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = this.getAlphabets().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            Alphabet alphabet = (Alphabet)iterator2.next();
            alphabet.validate(symbol);
            if (!(symbol instanceof AtomicSymbol)) continue;
            ++n;
        }
        if (n == list.size()) {
            return this.getSymbolImpl(list);
        }
        return AlphabetManager.createSymbol('*', Annotation.EMPTY_ANNOTATION, list, (Alphabet)this);
    }

    protected abstract AtomicSymbol getSymbolImpl(List var1) throws IllegalSymbolException;

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    public abstract Iterator iterator();

    public void putParser(String string, SymbolParser symbolParser) {
        this.parserByName.put(string, symbolParser);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.getChangeSupport(ChangeType.UNKNOWN).removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.getChangeSupport(changeType).removeChangeListener(changeListener, changeType);
    }

    public abstract void removeSymbol(Symbol var1) throws IllegalSymbolException, ChangeVetoException;

    public abstract int size();

    public abstract SymbolList symbols();

    public final void validate(Symbol symbol) throws IllegalSymbolException {
        if (!this.contains(symbol)) {
            StringBuffer stringBuffer = new StringBuffer("{");
            Iterator iterator = this.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((Symbol)iterator.next()).getToken());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(',');
                stringBuffer.append(((Symbol)iterator.next()).getToken());
            }
            stringBuffer.append("}");
            throw new IllegalSymbolException("Symbol " + symbol.getName() + " not found in alphabet " + this.getName() + " " + stringBuffer.toString());
        }
    }
}

