/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.seq.io.SeqFormatTools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;

public class GenbankFileFormer
implements SeqFileFormer {
    private static String featureDataFile = "org/biojava/bio/seq/io/FeatureQualifier.xml";
    private static Map featureData = new HashMap();
    private static Map qualifierData = new HashMap();
    private PrintStream stream;

    static {
        SeqFileFormerFactory.addFactory("Genbank", new Factory());
        SeqFormatTools.loadFeatureData(featureDataFile, featureData, qualifierData);
    }

    private GenbankFileFormer() {
    }

    private GenbankFileFormer(PrintStream printStream) {
        this.stream = printStream;
    }

    /* synthetic */ GenbankFileFormer(1 var1_1, PrintStream printStream) {
        this(printStream);
    }

    public void addFeatureProperty(Object object, Object object2) throws ParseException {
        String string = "                     ";
        StringBuffer stringBuffer = new StringBuffer("/" + object);
        String string2 = (String)((Map)qualifierData.get(object)).get("form");
        if (string2.equals("quoted")) {
            stringBuffer.append("=\"" + object2 + "\"");
        } else if (string2.equals("bare")) {
            stringBuffer.append("=" + object2);
        } else if (!string2.equals("empty")) {
            throw new ParseException("Unrecognised qualifier format: " + string2);
        }
        this.stream.println(SeqFormatTools.formatQualifierBlock(stringBuffer.toString(), string, 80));
    }

    public void addSequenceProperty(Object object, Object object2) throws ParseException {
        if (object.equals("genbank_accessions")) {
            StringBuffer stringBuffer = new StringBuffer("ACCESSION   ");
            Iterator iterator = ((List)object2).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append((String)iterator.next());
            }
            this.stream.println(stringBuffer);
        }
    }

    public void addSymbols(Alphabet alphabet, Symbol[] symbolArray, int n, int n2) throws IllegalAlphabetException {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < symbolArray.length) {
            char c = symbolArray[n8].getToken();
            switch (c) {
                case 'A': 
                case 'a': {
                    ++n3;
                    break;
                }
                case 'C': 
                case 'c': {
                    ++n4;
                    break;
                }
                case 'G': 
                case 'g': {
                    ++n5;
                    break;
                }
                case 'T': 
                case 't': {
                    ++n6;
                    break;
                }
                default: {
                    ++n7;
                }
            }
            ++n8;
        }
        StringBuffer stringBuffer = new StringBuffer("BASE COUNT    ");
        stringBuffer.append(String.valueOf(n3) + " a ");
        stringBuffer.append(String.valueOf(n3) + " c ");
        stringBuffer.append(String.valueOf(n3) + " g ");
        stringBuffer.append(String.valueOf(n3) + " t\nORIGIN\n");
        this.stream.println(stringBuffer.toString());
        int n9 = symbolArray.length / 60;
        int n10 = symbolArray.length % 60;
        int n11 = n9;
        if (n10 > 0) {
            ++n11;
        }
        int[] nArray = new int[n11];
        Arrays.fill(nArray, 60);
        nArray[n11 - 1] = n10;
        int n12 = 0;
        while (n12 < nArray.length) {
            int n13 = nArray[n12];
            StringBuffer stringBuffer2 = new StringBuffer(80);
            char[] cArray = new char[80];
            Arrays.fill(cArray, ' ');
            stringBuffer2.append(cArray);
            Symbol[] symbolArray2 = new Symbol[n13];
            System.arraycopy(symbolArray, n12 * 60, symbolArray2, 0, n13);
            String string = SeqFormatTools.formatTokenBlock(symbolArray2, 10).toString();
            stringBuffer2.replace(10, string.length() + 10, string);
            String string2 = Integer.toString(n12 * 60 + 1);
            stringBuffer2.replace(9 - string2.length(), 9, string2);
            this.stream.println(stringBuffer2);
            ++n12;
        }
        this.stream.println("//");
    }

    public void endFeature() throws ParseException {
    }

    public void endSequence() throws ParseException {
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }

    public void setName(String string) throws ParseException {
    }

    public void setPrintStream(PrintStream printStream) {
        this.stream = printStream;
    }

    public void setURI(String string) throws ParseException {
    }

    public void startFeature(Feature.Template template) throws ParseException {
        String string = "                     ";
        int n = 0;
        if (template instanceof StrandedFeature.Template) {
            n = ((StrandedFeature.Template)template).strand.getValue();
        }
        StringBuffer stringBuffer = SeqFormatTools.formatLocationBlock(template.location, n, string, 80);
        stringBuffer.replace(5, 5 + template.type.length(), template.type);
        this.stream.println(stringBuffer);
    }

    public void startSequence() throws ParseException {
    }

    private static class Factory
    extends SeqFileFormerFactory {
        Factory() {
        }

        protected SeqFileFormer make() {
            class Org_biojava_bio_seq_io_GenbankFileFormer$1 {
                /* synthetic */ Org_biojava_bio_seq_io_GenbankFileFormer$1() {
                }
            }
            return new GenbankFileFormer(null, System.out);
        }
    }
}

