/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PdbSAXParser
extends AbstractNativeAppSAXParser {
    private ArrayList oRecordList = new ArrayList();
    private String oRecord;
    private int iPos;
    private int iModelStart;
    private int iModelStop;
    private AttributesImpl oAtts = new AttributesImpl();
    private ArrayList oHeader = new ArrayList();
    private QName oAttQName = new QName(this);

    public PdbSAXParser() {
        this.setNamespacePrefix("biojava");
    }

    private boolean checkIfProtein(String string) {
        return true;
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        String string = null;
        BufferedReader bufferedReader = this.getContentStream(inputSource);
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                this.oRecordList.add(string);
                string = bufferedReader.readLine();
            }
            boolean bl = false;
            int n = 0;
            while (n < this.oRecordList.size()) {
                this.oRecord = (String)this.oRecordList.get(n);
                if (this.oRecord.startsWith("MODEL")) {
                    bl = true;
                    break;
                }
                ++n;
            }
            boolean bl2 = false;
            if (!bl) {
                int n2 = 0;
                while (n2 < this.oRecordList.size()) {
                    this.oRecord = (String)this.oRecordList.get(n2);
                    if (this.oRecord.startsWith("ATOM  ") && !bl2) {
                        bl2 = true;
                        this.oRecordList.add(n2, "MODEL        1");
                        break;
                    }
                    ++n2;
                }
                boolean bl3 = false;
                int n3 = this.oRecordList.size() - 1;
                while (n3 > 0) {
                    this.oRecord = (String)this.oRecordList.get(n3);
                    if ((this.oRecord.startsWith("ATOM  ") || this.oRecord.startsWith("HETATM") || this.oRecord.startsWith("TER")) && !bl3) {
                        bl3 = true;
                        this.oRecordList.add(n3 + 1, "ENDMDL");
                        break;
                    }
                    --n3;
                }
            }
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("MacromolecularStructure")), this.oAtts);
            this.iPos = 0;
            this.iModelStart = 0;
            this.iModelStop = 0;
            while (this.iPos < this.oRecordList.size()) {
                this.oRecord = (String)this.oRecordList.get(this.iPos);
                if (this.oRecord.startsWith("MODEL")) {
                    this.iModelStart = this.iPos;
                    String string2 = this.oRecord.substring(10, 14).trim();
                    this.oAtts.clear();
                    this.oAttQName.setQName("modelId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string2);
                    this.startElement(new QName(this, this.prefix("Model")), this.oAtts);
                }
                if (this.oRecord.startsWith("ENDMDL")) {
                    this.iModelStop = this.iPos;
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Protein")), this.oAtts);
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("ProteinChainList")), this.oAtts);
                    this.parseProtein(this.iModelStart, this.iModelStop);
                    this.endElement(new QName(this, this.prefix("Atom")));
                    this.endElement(new QName(this, this.prefix("Residue")));
                    this.endElement(new QName(this, this.prefix("ProteinChain")));
                    this.endElement(new QName(this, this.prefix("ProteinChainList")));
                    this.endElement(new QName(this, this.prefix("Model")));
                }
                ++this.iPos;
            }
            this.endElement(new QName(this, this.prefix("MacromolecularStructure")));
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("File read interupted");
        }
    }

    private void parseAtomRecord(String string) {
        System.out.println(string);
        String string2 = string.substring(21, 23);
        String string3 = string.substring(23, 27);
        string2 = string2.trim();
        string3 = string3.trim();
        System.out.println("ChainId>" + string2 + "<");
    }

    private void parseProtein(int n, int n2) throws SAXException {
        boolean bl = true;
        boolean bl2 = true;
        String string = "XXX";
        String string2 = "A*ZZ**";
        int n3 = n;
        while (n3 < n2) {
            this.oRecord = (String)this.oRecordList.get(n3);
            if (this.oRecord.startsWith("ATOM  ")) {
                String string3 = this.oRecord.substring(6, 11).trim();
                String string4 = this.oRecord.substring(12, 16).trim();
                String string5 = this.oRecord.substring(17, 20).trim();
                if (this.checkIfProtein(string5)) {
                    String string6 = this.oRecord.substring(21, 23).trim();
                    String string7 = this.oRecord.substring(23, 27).trim();
                    String string8 = this.oRecord.substring(30, 38).trim();
                    String string9 = this.oRecord.substring(38, 46).trim();
                    String string10 = this.oRecord.substring(47, 53).trim();
                    if (!string7.equals(string2)) {
                        if (!bl2) {
                            this.endElement(new QName(this, this.prefix("Residue")));
                        }
                        if (!string6.equals(string)) {
                            if (!bl) {
                                this.endElement(new QName(this, this.prefix("ProteinChain")));
                            }
                            this.oAtts.clear();
                            this.oAttQName.setQName("chainId");
                            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string6);
                            this.startElement(new QName(this, this.prefix("ProteinChain")), this.oAtts);
                            bl = false;
                            string = string6;
                        }
                        this.oAtts.clear();
                        this.oAttQName.setQName("residueId");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string7);
                        this.oAttQName.setQName("residueType");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string5);
                        this.startElement(new QName(this, this.prefix("Residue")), this.oAtts);
                        bl2 = false;
                        string2 = string7;
                    }
                    this.oAtts.clear();
                    this.oAttQName.setQName("atomId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string3);
                    this.oAttQName.setQName("atomType");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string4);
                    this.startElement(new QName(this, this.prefix("Atom")), this.oAtts);
                    this.oAtts.clear();
                    this.oAttQName.setQName("x");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string8);
                    this.oAttQName.setQName("y");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string9);
                    this.oAttQName.setQName("z");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string10);
                    this.startElement(new QName(this, this.prefix("Coordinates")), this.oAtts);
                    this.endElement(new QName(this, this.prefix("Coordinates")));
                    this.endElement(new QName(this, this.prefix("Atom")));
                }
            }
            ++n3;
        }
    }
}

