/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Comparator;
import java.util.TreeSet;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class TextLogoPainter
implements LogoPainter {
    private static final Comparator COMP = new ResValComparator();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Font logoFont = new Font("Tahoma", 0, 12);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.pcs.firePropertyChange(propertyChangeEvent);
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.pcs.firePropertyChange(string, n, n2);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.pcs.firePropertyChange(string, bl, bl2);
    }

    public Font getLogoFont() {
        return this.logoFont;
    }

    public boolean hasListeners(String string) {
        return this.pcs.hasListeners(string);
    }

    public void paintLogo(Graphics graphics, DistributionLogo distributionLogo) {
        Object object;
        Object object2;
        double d;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Distribution distribution = distributionLogo.getDistribution();
        SymbolStyle symbolStyle = distributionLogo.getStyle();
        Rectangle rectangle = distributionLogo.getBounds();
        double d2 = rectangle.getWidth();
        double d3 = d = rectangle.getHeight();
        double d4 = d * (distributionLogo.totalInformation() / distributionLogo.totalBits());
        TreeSet<ResVal> treeSet = new TreeSet<ResVal>(COMP);
        try {
            object2 = ((FiniteAlphabet)distribution.getAlphabet()).iterator();
            while (object2.hasNext()) {
                object = (Symbol)object2.next();
                treeSet.add(new ResVal((Symbol)object, distribution.getWeight((Symbol)object) * d4));
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Symbol dissapeared from dis alphabet");
        }
        object2 = graphics2D.getFontRenderContext();
        object = treeSet.iterator();
        while (object.hasNext()) {
            ResVal resVal = (ResVal)object.next();
            GlyphVector glyphVector = this.logoFont.createGlyphVector((FontRenderContext)object2, String.valueOf(resVal.getToken().getToken()));
            Shape shape = glyphVector.getOutline();
            Rectangle2D rectangle2D = shape.getBounds2D();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(0.0, d3 - resVal.getValue());
            affineTransform.scale(d2 / rectangle2D.getWidth(), resVal.getValue() / rectangle2D.getHeight());
            affineTransform.translate(-rectangle2D.getMinX(), -rectangle2D.getMinY());
            shape = affineTransform.createTransformedShape(shape);
            try {
                graphics2D.setPaint(symbolStyle.fillPaint(resVal.getToken()));
            }
            catch (IllegalSymbolException illegalSymbolException) {
                graphics2D.setPaint(Color.black);
            }
            graphics2D.fill(shape);
            try {
                graphics2D.setPaint(symbolStyle.outlinePaint(resVal.getToken()));
            }
            catch (IllegalSymbolException illegalSymbolException) {
                graphics2D.setPaint(Color.gray);
            }
            graphics2D.draw(shape);
            d3 -= resVal.getValue();
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setLogoFont(Font font) {
        this.firePropertyChange("logoFont", this.logoFont, font);
        this.logoFont = font;
    }

    private static class ResVal {
        private Symbol symbol;
        private double value;

        public ResVal(Symbol symbol, double d) {
            this.symbol = symbol;
            this.value = d;
        }

        public final Symbol getToken() {
            return this.symbol;
        }

        public final double getValue() {
            return this.value;
        }
    }

    private static class ResValComparator
    implements Comparator {
        ResValComparator() {
        }

        public final int compare(Object object, Object object2) {
            ResVal resVal = (ResVal)object;
            ResVal resVal2 = (ResVal)object2;
            double d = resVal.getValue() - resVal2.getValue();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return resVal.getToken().getToken() - resVal2.getToken().getToken();
        }
    }
}

