/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class SimpleSymbolStyle
implements SymbolStyle {
    private final Map outlinePaint = new HashMap();
    private final Map fillPaint = new HashMap();
    private final FiniteAlphabet alphabet;
    private static Map standardFillPaints = new HashMap();
    private static Map standardOutlinePaints = new HashMap();

    static {
        HashMap<Symbol, Color> hashMap = new HashMap<Symbol, Color>();
        hashMap.put(DNATools.t(), Color.red);
        hashMap.put(DNATools.g(), Color.blue);
        hashMap.put(DNATools.c(), Color.yellow);
        hashMap.put(DNATools.a(), Color.green);
        standardFillPaints.put(DNATools.getDNA(), hashMap);
        HashMap<Symbol, Color> hashMap2 = new HashMap<Symbol, Color>();
        hashMap2.put(DNATools.t(), Color.black);
        hashMap2.put(DNATools.a(), Color.black);
        hashMap2.put(DNATools.g(), Color.black);
        hashMap2.put(DNATools.c(), Color.black);
        standardOutlinePaints.put(DNATools.getDNA(), hashMap2);
    }

    public SimpleSymbolStyle(FiniteAlphabet finiteAlphabet) {
        this.alphabet = finiteAlphabet;
        Map map = SimpleSymbolStyle.getStandardOutlinePaints(finiteAlphabet);
        Map map2 = SimpleSymbolStyle.getStandardFillPaints(finiteAlphabet);
        try {
            if (map2 == null || map == null) {
                Iterator iterator = finiteAlphabet.iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    if (map == null) {
                        this.setOutlinePaint(symbol, Color.black);
                    } else {
                        this.setOutlinePaint(symbol, (Paint)map.get(symbol));
                    }
                    if (map2 == null) {
                        this.setFillPaint(symbol, Color.gray);
                        continue;
                    }
                    this.setOutlinePaint(symbol, (Paint)map2.get(symbol));
                }
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Symbol dissapeared from my alphabet");
        }
    }

    public Paint fillPaint(Symbol symbol) throws IllegalSymbolException {
        this.getAlphabet().validate(symbol);
        return (Paint)this.fillPaint.get(symbol);
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public static Map getStandardFillPaints(Alphabet alphabet) {
        return (Map)standardFillPaints.get(alphabet);
    }

    public static Map getStandardOutlinePaints(Alphabet alphabet) {
        return (Map)standardOutlinePaints.get(alphabet);
    }

    public Paint outlinePaint(Symbol symbol) throws IllegalSymbolException {
        this.getAlphabet().validate(symbol);
        return (Paint)this.outlinePaint.get(symbol);
    }

    public void setFillPaint(Symbol symbol, Paint paint) throws IllegalSymbolException {
        this.getAlphabet().validate(symbol);
        this.fillPaint.put(symbol, paint);
    }

    public void setOutlinePaint(Symbol symbol, Paint paint) throws IllegalSymbolException {
        this.getAlphabet().validate(symbol);
        this.outlinePaint.put(symbol, paint);
    }
}

