/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.WMAsMM;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlMarkovModel {
    private static void printTransitions(MarkovModel markovModel, State state, PrintStream printStream) throws IllegalSymbolException {
        Iterator iterator = markovModel.transitionsFrom(state).iterator();
        while (iterator.hasNext()) {
            State state2 = (State)iterator.next();
            try {
                printStream.println("  <transition from=\"" + (state instanceof MagicalState ? "_start_" : state.getName()) + "\" to=\"" + (state2 instanceof MagicalState ? "_end_" : state2.getName()) + "\" prob=\"" + markovModel.getWeights(state).getWeight(state2) + "\"/>");
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Transition listed in transitionsFrom(" + state.getName() + ") has dissapeared");
            }
        }
    }

    public static WeightMatrix readMatrix(Element element) throws IllegalSymbolException, IllegalAlphabetException, BioException {
        Element element2 = (Element)element.getElementsByTagName("alphabet").item(0);
        Alphabet alphabet = AlphabetManager.alphabetForName(element2.getAttribute("name"));
        if (!(alphabet instanceof FiniteAlphabet)) {
            throw new IllegalAlphabetException("Can't read WeightMatrix over infinite alphabet " + alphabet.getName() + " of type " + alphabet.getClass());
        }
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)alphabet;
        SymbolParser symbolParser = finiteAlphabet.getParser("token");
        SymbolParser symbolParser2 = finiteAlphabet.getParser("name");
        int n = 0;
        NodeList nodeList = element.getElementsByTagName("col");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            int n3 = Integer.parseInt(((Element)nodeList.item(n2)).getAttribute("indx"));
            n = Math.max(n, n3);
            ++n2;
        }
        SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(finiteAlphabet, n, DistributionFactory.DEFAULT);
        nodeList = element.getElementsByTagName("col");
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            Element element3 = (Element)nodeList.item(n4);
            int n5 = Integer.parseInt(element3.getAttribute("indx")) - 1;
            NodeList nodeList2 = element3.getElementsByTagName("weight");
            int n6 = 0;
            while (n6 < nodeList2.getLength()) {
                Element element4 = (Element)nodeList2.item(n6);
                String string = element4.getAttribute("res");
                Symbol symbol = string.length() > 1 ? symbolParser2.parseToken(string) : symbolParser.parseToken(string);
                try {
                    simpleWeightMatrix.getColumn(n5).setWeight(symbol, Double.parseDouble(element4.getAttribute("prob")));
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError("Assertion failure: Should be able to set the weights");
                }
                ++n6;
            }
            ++n4;
        }
        return simpleWeightMatrix;
    }

    public static MarkovModel readModel(Element element) throws BioException, IllegalSymbolException, IllegalAlphabetException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (element.getTagName().equals("WeightMatrix")) {
            return new WMAsMM(XmlMarkovModel.readMatrix(element));
        }
        int n = Integer.parseInt(element.getAttribute("heads"));
        Element element2 = (Element)element.getElementsByTagName("alphabet").item(0);
        Alphabet alphabet = AlphabetManager.alphabetForName(element2.getAttribute("name"));
        SimpleMarkovModel simpleMarkovModel = new SimpleMarkovModel(n, alphabet);
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        SymbolParser symbolParser = null;
        SymbolParser symbolParser2 = null;
        try {
            symbolParser = alphabet.getParser("name");
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            symbolParser2 = alphabet.getParser("token");
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (symbolParser == null && symbolParser2 == null) {
            throw new BioException("Couldn't find a parser for alphabet " + alphabet.getName());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("_start_", simpleMarkovModel.magicalState());
        hashMap.put("_end_", simpleMarkovModel.magicalState());
        hashMap.put("_START_", simpleMarkovModel.magicalState());
        hashMap.put("_END_", simpleMarkovModel.magicalState());
        NodeList nodeList = element.getElementsByTagName("state");
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            object4 = (Element)nodeList.item(n3);
            String string = object4.getAttribute("name");
            object3 = DistributionFactory.DEFAULT.createDistribution(alphabet);
            object2 = new SimpleEmissionState(string, Annotation.EMPTY_ANNOTATION, nArray, (Distribution)object3);
            hashMap.put(string, object2);
            object = object4.getElementsByTagName("weight");
            int n4 = 0;
            while (n4 < object.getLength()) {
                Element element3 = (Element)object.item(n4);
                String string2 = element3.getAttribute("res");
                Symbol symbol = string2.length() == 1 ? (symbolParser2 != null ? symbolParser2.parseToken(string2) : symbolParser.parseToken(string2)) : (symbolParser != null ? symbolParser.parseToken(string2) : symbolParser2.parseToken(string2));
                try {
                    object3.setWeight(symbol, Double.parseDouble(element3.getAttribute("prob")));
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException, "Assertion failure: Should be able to edit distribution");
                }
                ++n4;
            }
            try {
                simpleMarkovModel.addState((State)object2);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Assertion failure: Should be able to add states to model");
            }
            ++n3;
        }
        object4 = element.getElementsByTagName("transition");
        int n5 = 0;
        while (n5 < object4.getLength()) {
            object3 = (Element)object4.item(n5);
            object2 = (State)hashMap.get(object3.getAttribute("from"));
            object = (State)hashMap.get(object3.getAttribute("to"));
            double d = Double.parseDouble(object3.getAttribute("prob"));
            try {
                simpleMarkovModel.createTransition((State)object2, (State)object);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "We should have unlimited write-access to this model. Something is very wrong.");
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "We should have unlimited write-access to this model. Something is very wrong.");
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < object4.getLength()) {
            object2 = (Element)object4.item(n6);
            object = (State)hashMap.get(object2.getAttribute("from"));
            State state = (State)hashMap.get(object2.getAttribute("to"));
            double d = Double.parseDouble(object2.getAttribute("prob"));
            try {
                simpleMarkovModel.getWeights((State)object).setWeight(state, d);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "We should have unlimited write-access to this model. Something is very wrong.");
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "We should have unlimited write-access to this model. Something is very wrong.");
            }
            ++n6;
        }
        return simpleMarkovModel;
    }

    public static void writeMatrix(WeightMatrix weightMatrix, PrintStream printStream) throws Exception {
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)weightMatrix.getAlphabet();
        printStream.println("<MarkovModel>\n  <alphabet name=\"" + finiteAlphabet.getName() + "\"/>");
        int n = 0;
        while (n < weightMatrix.columns()) {
            printStream.println("  <col indx=\"" + (n + 1) + "\">");
            Iterator iterator = finiteAlphabet.iterator();
            while (iterator.hasNext()) {
                Symbol symbol = (Symbol)iterator.next();
                printStream.println("    <weight sym=\"" + symbol.getName() + "\" prob=\"" + weightMatrix.getColumn(n).getWeight(symbol) + "\"/>");
            }
            printStream.println("  </col>");
            ++n;
        }
        printStream.println("</MarkovModel>");
    }

    public static void writeModel(MarkovModel markovModel, PrintStream printStream) throws Exception {
        State state;
        Object object;
        markovModel = DP.flatView(markovModel);
        FiniteAlphabet finiteAlphabet = markovModel.stateAlphabet();
        FiniteAlphabet finiteAlphabet2 = (FiniteAlphabet)markovModel.emissionAlphabet();
        SymbolList symbolList = finiteAlphabet.symbols();
        List list = symbolList.toList();
        SymbolList symbolList2 = finiteAlphabet2.symbols();
        printStream.println("<MarkovModel heads=\"" + markovModel.heads() + "\">");
        printStream.println("<alphabet name=\"" + finiteAlphabet2.getName() + "\"/>");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (State)iterator.next();
            if (object instanceof MagicalState) continue;
            printStream.println("  <state name=\"" + object.getName() + "\">");
            if (object instanceof EmissionState) {
                state = (EmissionState)object;
                Distribution distribution = state.getDistribution();
                Iterator iterator2 = symbolList2.iterator();
                while (iterator2.hasNext()) {
                    Symbol symbol = (Symbol)iterator2.next();
                    printStream.println("    <weight sym=\"" + symbol.getName() + "\" prob=\"" + distribution.getWeight(symbol) + "\"/>");
                }
            }
            printStream.println("  </state>");
        }
        object = list.iterator();
        while (object.hasNext()) {
            state = (State)object.next();
            XmlMarkovModel.printTransitions(markovModel, state, printStream);
        }
        printStream.println("</MarkovModel>");
    }
}

