/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.SimpleDotState;
import org.biojava.bio.dp.SimpleEmissionState;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;

public class ProfileHMM
extends SimpleMarkovModel {
    private static final int[] advance = new int[]{1};
    private final int columns;
    private final EmissionState[] matchStates;
    private final EmissionState[] insertStates;
    private final DotState[] deleteStates;

    public ProfileHMM(Alphabet alphabet, int n, DistributionFactory distributionFactory, DistributionFactory distributionFactory2) throws IllegalSymbolException, IllegalTransitionException, IllegalAlphabetException {
        super(1, alphabet);
        try {
            this.columns = n;
            this.matchStates = new EmissionState[n + 2];
            this.insertStates = new EmissionState[n + 1];
            this.deleteStates = new DotState[n];
            SimpleEmissionState simpleEmissionState = this.magicalState();
            SimpleEmissionState simpleEmissionState2 = new SimpleEmissionState("i-0", Annotation.EMPTY_ANNOTATION, advance, distributionFactory2.createDistribution(alphabet));
            SimpleDotState simpleDotState = null;
            this.matchStates[0] = simpleEmissionState;
            this.insertStates[0] = simpleEmissionState2;
            this.addState(simpleEmissionState2);
            this.createTransition(simpleEmissionState, simpleEmissionState2);
            this.createTransition(simpleEmissionState2, simpleEmissionState2);
            int n2 = 1;
            while (n2 <= n) {
                SimpleEmissionState simpleEmissionState3 = new SimpleEmissionState("m-" + n2, Annotation.EMPTY_ANNOTATION, advance, distributionFactory.createDistribution(alphabet));
                SimpleEmissionState simpleEmissionState4 = new SimpleEmissionState("i-" + n2, Annotation.EMPTY_ANNOTATION, advance, distributionFactory2.createDistribution(alphabet));
                SimpleDotState simpleDotState2 = new SimpleDotState("d-" + n2);
                this.addState(simpleEmissionState3);
                this.addState(simpleEmissionState4);
                this.addState(simpleDotState2);
                this.matchStates[n2] = simpleEmissionState3;
                this.insertStates[n2] = simpleEmissionState3;
                this.deleteStates[n2 - 1] = simpleDotState2;
                this.createTransition(simpleEmissionState, simpleEmissionState3);
                this.createTransition(simpleEmissionState3, simpleEmissionState4);
                this.createTransition(simpleEmissionState, simpleDotState2);
                this.createTransition(simpleEmissionState4, simpleEmissionState4);
                this.createTransition(simpleEmissionState2, simpleEmissionState3);
                this.createTransition(simpleEmissionState2, simpleDotState2);
                if (n2 > 1) {
                    this.createTransition(simpleDotState, simpleDotState2);
                    this.createTransition(simpleDotState, simpleEmissionState3);
                    this.createTransition(simpleDotState2, simpleEmissionState4);
                }
                simpleEmissionState = simpleEmissionState3;
                simpleEmissionState2 = simpleEmissionState4;
                simpleDotState = simpleDotState2;
                ++n2;
            }
            this.createTransition(simpleEmissionState, this.magicalState());
            this.createTransition(simpleEmissionState2, this.magicalState());
            this.createTransition(simpleDotState, this.magicalState());
            this.matchStates[n + 1] = this.magicalState();
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Unable to construct profile HMM");
        }
    }

    public int columns() {
        return this.columns;
    }

    public DotState getDelete(int n) throws IndexOutOfBoundsException {
        if (n < 1 || n > this.columns) {
            throw new IndexOutOfBoundsException("delete-state index must be within (1.." + this.columns + "), not " + n);
        }
        return this.deleteStates[n - 1];
    }

    public EmissionState getInsert(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.columns) {
            throw new IndexOutOfBoundsException("Insert-state index must be within (0.." + this.columns + "), not " + n);
        }
        return this.insertStates[n];
    }

    public EmissionState getMatch(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.columns + 1) {
            throw new IndexOutOfBoundsException("Match-state index must be within (0.." + (this.columns + 1) + "), not " + n);
        }
        return this.matchStates[n];
    }
}

