/*
 * Decompiled with CFR 0.152.
 */
package jal.DOUBLE;

import jal.DOUBLE.BinaryOperator;

public final class Numeric {
    public static double accumulate(double[] dArray, int n, int n2, double d) {
        double d2 = d;
        while (n < n2) {
            d2 += dArray[n++];
        }
        return d2;
    }

    public static double accumulate(double[] dArray, int n, int n2, double d, BinaryOperator binaryOperator) {
        double d2 = d;
        while (n < n2) {
            d2 = binaryOperator.apply(d2, dArray[n++]);
        }
        return d2;
    }

    public static double inner_product(double[] dArray, double[] dArray2, int n, int n2, int n3, double d) {
        double d2 = d;
        while (n < n2) {
            d2 += dArray[n++] * dArray2[n3++];
        }
        return d2;
    }

    public static double inner_product(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        double d2 = d;
        while (n < n2) {
            d2 = binaryOperator.apply(d2, binaryOperator2.apply(dArray[n++], dArray2[n3++]));
        }
        return d2;
    }

    public static int partial_sum(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        if (n < n2) {
            dArray2[n3] = dArray[n];
            double d = dArray2[n3];
            while (++n < n2) {
                dArray2[++n3] = d += dArray[n];
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(double[] dArray, double[] dArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            dArray2[n3] = dArray[n];
            double d = dArray2[n3];
            while (++n < n2) {
                d = binaryOperator.apply(d, dArray[n]);
                dArray2[++n3] = d;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        if (n < n2) {
            dArray2[n3] = dArray[n];
            double d = dArray[n];
            while (++n < n2) {
                double d2 = dArray[n];
                dArray2[++n3] = d2 - d;
                d = d2;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(double[] dArray, double[] dArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            dArray2[n3] = dArray[n];
            double d = dArray[n];
            while (++n < n2) {
                double d2 = dArray[n];
                dArray2[++n3] = binaryOperator.apply(d2, d);
                d = d2;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

