/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.Constraint;
import eponine.model.ReverseComplementWeightMatrix;
import java.io.Serializable;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;

public class WeightMatrixConstraint
implements Constraint,
Serializable {
    private WeightMatrix wm;
    private WeightMatrix reverseWM;
    private double reversibility;

    public WeightMatrixConstraint(WeightMatrix weightMatrix, double d) {
        this.wm = weightMatrix;
        this.reversibility = weightMatrix.getAlphabet() == DNATools.getDNA() ? d : 0.0;
    }

    public WeightMatrix getWeightMatrix() {
        return this.wm;
    }

    public WeightMatrix getReverseWeightMatrix() {
        if (this.reverseWM == null) {
            try {
                this.reverseWM = new ReverseComplementWeightMatrix(this.wm);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException);
            }
        }
        return this.reverseWM;
    }

    public double getReversibility() {
        return this.reversibility;
    }

    public double evaluate(SymbolList symbolList, int n) {
        double d = 0.0;
        try {
            WeightMatrix weightMatrix = this.getWeightMatrix();
            Alphabet alphabet = weightMatrix.getAlphabet();
            int n2 = alphabet.getAlphabets().size();
            if (n2 > 1) {
                symbolList = SymbolListViews.orderNSymbolList(symbolList, n2);
                n += n2 - 1;
            }
            d = this.evalWM(symbolList, n, weightMatrix);
            if (this.reversibility > 0.0) {
                double d2 = this.evalWM(symbolList, n, this.getReverseWeightMatrix());
                d = (1.0 - this.reversibility) * d + this.reversibility * d2;
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new RuntimeException("Unknown symbol.");
        }
        catch (IllegalAlphabetException illegalAlphabetException) {
            throw new BioError(illegalAlphabetException);
        }
        return d / Math.pow(0.25, this.wm.columns());
    }

    public double nullModel(SymbolList symbolList, int n) {
        return Math.pow(0.25, this.wm.columns());
    }

    public double divisor() {
        return this.wm.columns();
    }

    private double evalWM(SymbolList symbolList, int n, WeightMatrix weightMatrix) throws IllegalSymbolException {
        double d = 1.0;
        int n2 = symbolList.length();
        int n3 = 0;
        while (n3 < this.wm.columns()) {
            int n4 = n + n3;
            if (n4 < 1 || n4 > n2) {
                d *= 0.25;
            } else {
                Symbol symbol = symbolList.symbolAt(n + n3);
                d *= weightMatrix.getColumn(n3).getWeight(symbol);
            }
            ++n3;
        }
        return d;
    }

    public int hashCode() {
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < this.wm.columns()) {
                n *= 100;
                Distribution distribution = this.wm.getColumn(n2);
                int n3 = 1;
                Iterator iterator = ((FiniteAlphabet)this.wm.getAlphabet()).iterator();
                while (iterator.hasNext()) {
                    n += (int)(distribution.getWeight((Symbol)iterator.next()) * 10.0 * (double)n3);
                    n3 += 2;
                }
                ++n2;
            }
            return n;
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new RuntimeException("Uncooperative WM.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof WeightMatrixConstraint)) {
            return false;
        }
        WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)object;
        if (weightMatrixConstraint.getReversibility() != this.reversibility) {
            return false;
        }
        WeightMatrix weightMatrix = weightMatrixConstraint.getWeightMatrix();
        if (weightMatrix.columns() != this.wm.columns()) {
            return false;
        }
        if (weightMatrix.getAlphabet() != this.wm.getAlphabet()) {
            return false;
        }
        try {
            int n = 0;
            while (n < this.wm.columns()) {
                Distribution distribution = this.wm.getColumn(n);
                Distribution distribution2 = weightMatrix.getColumn(n);
                Iterator iterator = ((FiniteAlphabet)distribution.getAlphabet()).iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    if (distribution.getWeight(symbol) == distribution2.getWeight(symbol)) continue;
                    return false;
                }
                ++n;
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new RuntimeException("Uncooperative WM.");
        }
        return true;
    }
}

