/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import eponine.model.BasisFunctionWithHistory;
import eponine.model.ConstraintBasisFunction;
import eponine.model.EponineXML;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.utils.xml.Initializable;
import org.xml.sax.InputSource;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.GLMClassificationModel;
import stats.glm.ListBasisSource;
import stats.glm.SLMTrainingContext;

public class ModelFileBasisSource
extends FundamentalAtomicSymbol
implements BasisSource,
Initializable {
    private String fileName;
    private BasisSource bs;

    public ModelFileBasisSource() {
        super("modelfile", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getName() {
        return this.fileName;
    }

    public void init() {
        try {
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = Resolver.createInputSource((File)new File(this.fileName));
            XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(xmlDocument.getDocumentElement());
            this.bs = new ListBasisSource(new ArrayList(gLMClassificationModel.getBasisFunctions()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return this.bs.hasNext(sLMTrainingContext);
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        BasisFunction basisFunction = this.bs.next(sLMTrainingContext);
        if (basisFunction instanceof ConstraintBasisFunction) {
            basisFunction = new BasisFunctionWithHistory(basisFunction, Collections.EMPTY_SET, this, sLMTrainingContext.getCurrentCycle());
        }
        return basisFunction;
    }
}

