/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import com.sun.xml.parser.Resolver;
import com.sun.xml.tree.XmlDocument;
import eponine.model.EponineXML;
import eponine.model.FastModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.xml.AppEntry;
import org.xml.sax.InputSource;
import stats.glm.GLMClassificationModel;

public class EvaluateCore
implements AppEntry {
    private String fileName;
    private String testFileName;
    private String seqPrefix;
    private int clusterTolerance;
    private int intervalUp = 0;
    private int intervalDown = 0;
    private SequenceFormat seqFormat;
    private double threshold = 0.999;
    private boolean doTrace = false;

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setTestFileName(String string) {
        this.testFileName = string;
    }

    public void setSeqPrefix(String string) {
        this.seqPrefix = string;
    }

    public void setSeqFormat(SequenceFormat sequenceFormat) {
        this.seqFormat = sequenceFormat;
    }

    public void setClusterTolerance(int n) {
        this.clusterTolerance = n;
    }

    public void setIntervalUp(int n) {
        this.intervalUp = n;
    }

    public void setIntervalDown(int n) {
        this.intervalDown = n;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    public void setDoTrace(boolean bl) {
        this.doTrace = bl;
    }

    public void start(String[] stringArray) {
        try {
            String string;
            EponineXML eponineXML = new EponineXML();
            InputSource inputSource = Resolver.createInputSource((File)new File(this.fileName));
            XmlDocument xmlDocument = XmlDocument.createXmlDocument((InputSource)inputSource, (boolean)false);
            GLMClassificationModel gLMClassificationModel = eponineXML.xmlToModel(xmlDocument.getDocumentElement());
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.testFileName));
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                Object object2;
                int n4 = string.indexOf(35);
                if (n4 == 0) continue;
                if (n4 > 0) {
                    string = string.substring(0, n4);
                }
                if ((string = string.trim()).length() == 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string2 = stringTokenizer.nextToken();
                System.out.print("> " + string2);
                String string3 = this.seqPrefix + string2;
                HashSet<RangeLocation> hashSet = new HashSet<RangeLocation>();
                while (stringTokenizer.hasMoreTokens()) {
                    int n5;
                    object2 = stringTokenizer.nextToken();
                    object = new StringTokenizer((String)object2, "r-/");
                    if (((StringTokenizer)object).countTokens() == 1) {
                        n5 = Integer.parseInt(((StringTokenizer)object).nextToken());
                        hashSet.add(new RangeLocation(n5 - this.intervalUp, n5 + this.intervalDown));
                        continue;
                    }
                    n5 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    int n6 = Integer.parseInt(((StringTokenizer)object).nextToken());
                    hashSet.add(new RangeLocation(n5 - this.intervalUp, n6 + this.intervalDown));
                }
                object2 = new BufferedReader(new FileReader(string3));
                object = new StreamReader((BufferedReader)object2, this.seqFormat, DNATools.getDNA().getParser("token"), SimpleSequenceBuilder.FACTORY);
                Sequence sequence = ((StreamReader)object).nextSequence();
                System.out.println("...loaded");
                n3 += sequence.length();
                FastModel fastModel = new FastModel(gLMClassificationModel, sequence, 2000);
                int n7 = -1000;
                int n8 = -1000;
                HashSet<Location> hashSet2 = new HashSet<Location>();
                PrintWriter printWriter = null;
                if (this.doTrace) {
                    printWriter = new PrintWriter(new FileWriter("traces/" + string2 + ".trace"));
                }
                int n9 = 1;
                while (n9 < sequence.length()) {
                    if (n9 - n7 > this.clusterTolerance || n9 == sequence.length() - 1) {
                        if (n8 > 0) {
                            Location location = null;
                            RangeLocation rangeLocation = new RangeLocation(n8, n7);
                            Iterator iterator = hashSet.iterator();
                            while (iterator.hasNext()) {
                                Location location2 = (Location)iterator.next();
                                if (!rangeLocation.overlaps(location2)) continue;
                                location = location2;
                            }
                            if (location != null) {
                                hashSet2.add(location);
                            } else {
                                ++n2;
                            }
                        }
                        n8 = -1000;
                    }
                    double d = fastModel.score(n9);
                    if (printWriter != null) {
                        printWriter.println("" + n9 + " " + Math.log(1.0 - d) / Math.log(10.0));
                    }
                    if (d > this.threshold) {
                        n7 = n9;
                        if (n8 < 0) {
                            n8 = n9;
                        }
                    }
                    ++n9;
                }
                System.out.println(hashSet2.size());
                n += hashSet2.size();
                if (printWriter == null) continue;
                printWriter.close();
            }
            System.out.println("Bases: " + n3);
            System.out.println("Found: " + n);
            System.out.println("False: " + n2);
            System.out.println("Bases per error: " + n3 / n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

