/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.utils.scenegraph.Component;
import org.biojava.utils.scenegraph.Composite;

public abstract class Joiner
extends Composite {
    private Hashtable coordinateSpaces;

    public void addCoordinateSpace(String string, Component component) throws NoSuchElementException {
        Iterator iterator = component.getChildIterator();
        while (iterator.hasNext()) {
            if (iterator.next() != this) continue;
            this.coordinateSpaces.put(string, component);
            return;
        }
        throw new NoSuchElementException("The component must be a descendant of the Joiner:\nthis = " + this + "\ncomponent = " + component + "\nname = " + string);
    }

    Component getComponentForCoordinateSpace(String string) throws NoSuchElementException {
        Object v = this.coordinateSpaces.get(string);
        if (v != null) {
            return (Component)v;
        }
        throw new NoSuchElementException("Co-ordinate space '" + string + "' doesn't exist in " + this);
    }

    public void removeCoordinateSpace(String string) throws NoSuchElementException {
        if (this.coordinateSpaces.remove(string) == null) {
            throw new NoSuchElementException("Co-ordinate space '" + string + "' doesn't exist in " + this);
        }
    }

    protected AffineTransform calculateTransformToCoordinateSpace(String string) throws NoSuchElementException {
        Component component = this.getComponentForCoordinateSpace(string);
        AffineTransform affineTransform = new AffineTransform();
        Iterator iterator = component.getParentIterator();
        while (iterator.hasNext()) {
            affineTransform.preConcatenate(((Component)iterator.next()).getDrawingTransform());
        }
        return affineTransform;
    }

    public void draw(Graphics2D graphics2D) {
        super.draw(graphics2D);
        this.drawOverlay(graphics2D);
    }

    protected abstract void drawOverlay(Graphics2D var1);
}

