/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import org.biojava.stats.svm.NestedKernel;
import org.biojava.stats.svm.SVMKernel;

public class RadialBaseKernel
extends NestedKernel {
    private double width;

    public RadialBaseKernel() {
        this(null, 1.0);
    }

    public RadialBaseKernel(SVMKernel sVMKernel, double d) {
        super(sVMKernel);
        this.width = d;
    }

    public double evaluate(Object object, Object object2) {
        SVMKernel sVMKernel = this.getNestedKernel();
        double d = this.getWidth();
        return Math.exp(-Math.abs(2.0 * sVMKernel.evaluate(object, object2) - sVMKernel.evaluate(object, object) - sVMKernel.evaluate(object2, object2)) / (2.0 * d * d));
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public String toString() {
        return "Radial base kernel K(x, k) = exp(-abs(k(x,x) - k(y,y)) / (2*" + this.getWidth() + "^2)" + "; k = " + this.getNestedKernel().toString();
    }
}

