/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Collections;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class WindowedSymbolList
extends AbstractSymbolList
implements Serializable {
    private final SymbolList source;
    private final Alphabet alpha;
    private final int width;

    public WindowedSymbolList(SymbolList symbolList, int n) throws IllegalArgumentException {
        if (symbolList.length() % n != 0) {
            throw new IllegalArgumentException("The source length must be divisible by the window width: " + symbolList.length() + " % " + n + " = " + symbolList.length() % n);
        }
        this.source = symbolList;
        Alphabet alphabet = symbolList.getAlphabet();
        this.alpha = AlphabetManager.getCrossProductAlphabet(Collections.nCopies(n, alphabet));
        this.width = n;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public SymbolList getSource() {
        return this.source;
    }

    public int length() {
        return this.source.length() / this.width;
    }

    public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
        if (n < 1 || n > this.length()) {
            throw new IndexOutOfBoundsException("index must be within (1 .. " + this.length() + "), not " + n);
        }
        n = (n - 1) * this.width + 1;
        try {
            return this.alpha.getSymbol(this.source.subList(n, n + this.width - 1).toList());
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Alphabet changed underneath me");
        }
    }
}

