/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.program.search.GappedSymbolListBuilder;
import org.biojava.bio.program.search.SearchBuilder;
import org.biojava.bio.program.search.SearchParser;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.search.SequenceDBSearchHit;
import org.biojava.bio.search.SequenceDBSearchResult;
import org.biojava.bio.search.SequenceDBSearchSubHit;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class FastaSearchBuilder
implements SearchBuilder {
    private SearchParser parser;
    private SequenceDBInstallation subjectDBs;
    private SequenceDB subjectDB;
    private SequenceDB querySeqHolder;
    private SymbolList querySeq;
    private Annotation hitAnnotation;
    private Annotation resultAnnotation;
    private Map resultPreAnnotation;
    private Map searchParameters;
    private Map hitPreAnnotation;
    private Map hitData;
    private ArrayList searchHits = new ArrayList();

    public FastaSearchBuilder(SequenceDBInstallation sequenceDBInstallation, SequenceDB sequenceDB) {
        this.subjectDBs = sequenceDBInstallation;
        this.querySeqHolder = sequenceDB;
    }

    private Alignment createAlignment(String string, Map map) throws IllegalSymbolException {
        String string2 = (String)map.get("query");
        FiniteAlphabet finiteAlphabet = string2.equals("dna") ? DNATools.getDNA() : ProteinTools.getAlphabet();
        StringBuffer stringBuffer = new StringBuffer(this.prepSeqTokens("query", map));
        StringBuffer stringBuffer2 = new StringBuffer(this.prepSeqTokens("subject", map));
        HashMap<String, SymbolList> hashMap = new HashMap<String, SymbolList>();
        GappedSymbolListBuilder gappedSymbolListBuilder = new GappedSymbolListBuilder(finiteAlphabet);
        hashMap.put("Query", gappedSymbolListBuilder.makeGappedSymbolList(stringBuffer));
        hashMap.put(string, gappedSymbolListBuilder.makeGappedSymbolList(stringBuffer2));
        return new SimpleAlignment(hashMap);
    }

    private Annotation createAnnotation(Map map) {
        SimpleAnnotation simpleAnnotation = new SimpleAnnotation();
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            try {
                simpleAnnotation.setProperty(k, v);
            }
            catch (ChangeVetoException changeVetoException) {
                changeVetoException.printStackTrace();
            }
        }
        return simpleAnnotation;
    }

    private SeqSimilaritySearchHit createHit(Map map, Annotation annotation) throws BioException {
        String string = (String)map.get("id");
        Double d = (Double)map.get("fa_z-score");
        Double d2 = (Double)map.get("fa_expect");
        Double d3 = (Double)map.get("fa_expect");
        ArrayList<SequenceDBSearchSubHit> arrayList = new ArrayList<SequenceDBSearchSubHit>();
        try {
            Alignment alignment = this.createAlignment(string, map);
            SequenceDBSearchSubHit sequenceDBSearchSubHit = new SequenceDBSearchSubHit(d, d2, d3, alignment);
            arrayList.add(sequenceDBSearchSubHit);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioException("Failed to create alignment for hit to " + string);
        }
        return new SequenceDBSearchHit(string, d, d2, d3, arrayList, annotation);
    }

    public void endHeader() {
        this.resultAnnotation = this.createAnnotation(this.resultPreAnnotation);
    }

    public void endHit() {
    }

    public void endSearch() {
    }

    public void endSubHit() {
        this.hitAnnotation = this.createAnnotation(this.hitPreAnnotation);
        try {
            SeqSimilaritySearchHit seqSimilaritySearchHit = this.createHit(this.hitData, this.hitAnnotation);
            this.searchHits.add(seqSimilaritySearchHit);
        }
        catch (BioException bioException) {
            bioException.printStackTrace();
        }
    }

    public SeqSimilaritySearchResult makeSearchResult() throws BioException {
        return new SequenceDBSearchResult(this.subjectDB, this.searchParameters, this.querySeq, this.resultAnnotation, this.searchHits);
    }

    private String prepSeqTokens(String string, Map map) {
        Integer n = (Integer)map.get(String.valueOf(string) + "AlDispStart");
        Integer n2 = (Integer)map.get(String.valueOf(string) + "AlStart");
        Integer n3 = (Integer)map.get(String.valueOf(string) + "AlStop");
        StringBuffer stringBuffer = new StringBuffer((String)map.get(String.valueOf(string) + "SeqTokens"));
        while (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringBuffer.length()) {
            if (stringBuffer.charAt(n5) == '-') {
                ++n4;
            }
            ++n5;
        }
        return stringBuffer.substring(n2 - n, n3 - n + n4 + 1);
    }

    void setHitAnnotationData(Map map) {
        this.hitPreAnnotation = map;
    }

    void setHitData(Map map) {
        this.hitData = map;
    }

    void setQuerySeq(String string) throws BioException {
        try {
            this.querySeq = this.querySeqHolder.getSequence(string);
        }
        catch (BioException bioException) {
            throw new BioException(bioException, "Failed to retrieve query sequence from holder using ID: " + string);
        }
    }

    void setSearchAnnotationData(Map map) {
        this.resultPreAnnotation = map;
    }

    void setSearchResultData(Map map) {
        this.searchParameters = map;
    }

    void setSubjectDB(String string) throws BioException {
        this.subjectDB = this.subjectDBs.getSequenceDB(string);
        if (this.subjectDB == null) {
            throw new BioException("Failed to retrieve database from installation using ID: " + string);
        }
    }

    public void startHeader() {
    }

    public void startHit() {
    }

    public void startSearch() {
    }

    public void startSubHit() {
    }
}

