/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASComponentFeature;
import org.biojava.bio.program.das.DASFeatureSet;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.impl.AssembledSymbolList;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheReference;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DASSequence
implements Sequence,
RealizingFeatureHolder {
    public static final ChangeType ANNOTATIONS = new ChangeType("Annotation sets have been added or removed from the DAS sequence", "org.biojava.bio.program.das.DASSequence", "ANNOTATIONS", FeatureHolder.FEATURES);
    public static final String PROPERTY_ANNOTATIONSERVER = "org.biojava.bio.program.das.annotation_server";
    public static final String PROPERTY_FEATUREID = "org.biojava.bio.program.das.feature_id";
    public static final String PROPERTY_FEATURELABEL = "org.biojava.bio.program.das.feature_label";
    public static final int SIZE_THRESHOLD = 1000000;
    private DASSequenceDB parentdb;
    private Alphabet alphabet = DNATools.getDNA();
    private URL dataSourceURL;
    private String seqID;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    private FeatureRequestManager.Ticket structureTicket;
    private CacheReference refSymbols;
    private int length = -1;
    private Map featureSets = new HashMap();
    private FeatureHolder structure;
    private MergeFeatureHolder features = new MergeFeatureHolder();
    protected transient ChangeSupport changeSupport = null;
    static /* synthetic */ Class class$org$biojava$bio$seq$ComponentFeature;

    DASSequence(DASSequenceDB dASSequenceDB, URL uRL, String string) throws BioException {
        this(dASSequenceDB, uRL, string, Collections.singleton(uRL));
    }

    DASSequence(DASSequenceDB dASSequenceDB, URL uRL, String string, Set set) throws BioException {
        this.parentdb = dASSequenceDB;
        this.dataSourceURL = uRL;
        this.seqID = string;
        this.structure = new SimpleFeatureHolder();
        SkeletonListener skeletonListener = new SkeletonListener();
        FeatureRequestManager featureRequestManager = FeatureRequestManager.getManager(uRL);
        this.structureTicket = featureRequestManager.requestFeatures(string, skeletonListener, null, "component");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            URL uRL2 = (URL)iterator.next();
            DASFeatureSet dASFeatureSet = new DASFeatureSet(this, uRL2, string);
            this.featureSets.put(uRL2, dASFeatureSet);
            this.features.addFeatureHolder(dASFeatureSet);
        }
    }

    private void _addAnnotationSource(URL uRL) throws BioException, ChangeVetoException {
        FeatureHolder featureHolder = this.getStructure();
        if (!this.featureSets.containsKey(uRL)) {
            FeatureHolder featureHolder2;
            Iterator iterator = featureHolder.features();
            while (iterator.hasNext()) {
                featureHolder2 = (DASComponentFeature)iterator.next();
                DASSequence dASSequence = featureHolder2.getSequenceLazy();
                if (dASSequence == null) continue;
                dASSequence.addAnnotationSource(uRL);
            }
            featureHolder2 = new DASFeatureSet(this, uRL, this.seqID);
            this.featureSets.put(uRL, featureHolder2);
            this.features.addFeatureHolder(featureHolder2);
        }
    }

    private void _removeAnnotationSource(URL uRL) throws ChangeVetoException, BioException {
        FeatureHolder featureHolder = this.getStructure();
        FeatureHolder featureHolder2 = (FeatureHolder)this.featureSets.get(uRL);
        if (featureHolder2 != null) {
            Iterator iterator = featureHolder.features();
            while (iterator.hasNext()) {
                DASComponentFeature dASComponentFeature = (DASComponentFeature)iterator.next();
                DASSequence dASSequence = dASComponentFeature.getSequenceLazy();
                if (dASSequence == null) continue;
                dASSequence.removeAnnotationSource(uRL);
            }
            this.features.removeFeatureHolder(featureHolder2);
            this.featureSets.remove(uRL);
        }
    }

    public void addAnnotationSource(URL uRL) throws BioException, ChangeVetoException {
        if (this.changeSupport == null) {
            this._addAnnotationSource(uRL);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, ANNOTATIONS, null, null);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this._addAnnotationSource(uRL);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean containsFeature(Feature feature) {
        return this.features.containsFeature(feature);
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public Set dataSourceURLs() {
        return Collections.unmodifiableSet(this.featureSets.keySet());
    }

    public void edit(Edit edit) throws ChangeVetoException {
        throw new ChangeVetoException("/You/ try implementing read-write DAS");
    }

    public Iterator features() {
        try {
            this.registerFeatureFetchers();
            return this.features.features();
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Couldn't create features iterator");
        }
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        try {
            Object object;
            FeatureHolder featureHolder = this.getStructure();
            if (featureFilter instanceof FeatureFilter.ByClass && ((FeatureFilter.ByClass)(object = (FeatureFilter.ByClass)featureFilter)).getTestClass() == (class$org$biojava$bio$seq$ComponentFeature != null ? class$org$biojava$bio$seq$ComponentFeature : (class$org$biojava$bio$seq$ComponentFeature = DASSequence.class$("org.biojava.bio.seq.ComponentFeature")))) {
                if (bl) {
                    SimpleFeatureHolder simpleFeatureHolder = new SimpleFeatureHolder();
                    try {
                        Iterator iterator = featureHolder.features();
                        while (iterator.hasNext()) {
                            Feature feature = (Feature)iterator.next();
                            simpleFeatureHolder.addFeature(feature);
                            Iterator iterator2 = feature.filter(featureFilter, true).features();
                            while (iterator2.hasNext()) {
                                simpleFeatureHolder.addFeature((Feature)iterator2.next());
                            }
                        }
                    }
                    catch (ChangeVetoException changeVetoException) {
                        throw new BioError(changeVetoException, "Assertion failure");
                    }
                    return simpleFeatureHolder;
                }
                return featureHolder;
            }
            if (featureFilter instanceof FeatureFilter.OverlapsLocation || featureFilter instanceof FeatureFilter.ContainedByLocation) {
                object = null;
                object = featureFilter instanceof FeatureFilter.OverlapsLocation ? ((FeatureFilter.OverlapsLocation)featureFilter).getLocation() : ((FeatureFilter.ContainedByLocation)featureFilter).getLocation();
                this.registerFeatureFetchers((Location)object);
            } else {
                this.registerFeatureFetchers();
            }
            return this.features.filter(featureFilter, bl);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't filter");
        }
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    URL getDataSourceURL() {
        return this.dataSourceURL;
    }

    public String getName() {
        return this.seqID;
    }

    DASSequenceDB getParentDB() {
        return this.parentdb;
    }

    private FeatureHolder getStructure() throws BioException {
        if (!this.structureTicket.isFetched()) {
            this.structureTicket.doFetch();
            if (this.structure.countFeatures() > 0) {
                this.features.addFeatureHolder(this.structure);
            }
        }
        return this.structure;
    }

    protected SymbolList getSymbols() throws BioException {
        SymbolList symbolList = null;
        if (this.refSymbols != null) {
            symbolList = (SymbolList)this.refSymbols.get();
        }
        if (symbolList == null) {
            FeatureHolder featureHolder = this.getStructure();
            if (featureHolder.countFeatures() == 0) {
                symbolList = this.getTrueSymbols();
            } else {
                AssembledSymbolList assembledSymbolList = new AssembledSymbolList();
                assembledSymbolList.setLength(this.length);
                Iterator iterator = featureHolder.features();
                while (iterator.hasNext()) {
                    ComponentFeature componentFeature = (ComponentFeature)iterator.next();
                    assembledSymbolList.putComponent(componentFeature.getLocation(), componentFeature);
                }
                symbolList = assembledSymbolList;
            }
            this.refSymbols = this.parentdb.getSymbolsCache().makeReference(symbolList);
        }
        return symbolList;
    }

    protected SymbolList getTrueSymbols() {
        try {
            URL uRL = new URL(this.dataSourceURL, "dna?ref=" + this.seqID);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioError("Not a DAS server");
            }
            if (n != 200) {
                throw new BioError("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = DASSequence.nonvalidatingParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("DNA");
            if (nodeList.getLength() < 1) {
                throw new BioError("Didn't find DNA element");
            }
            element = (Element)nodeList.item(0);
            int n2 = Integer.parseInt(element.getAttribute("length"));
            if (this.length >= 0 && n2 != this.length()) {
                throw new BioError("Returned DNA length incorrect: expecting " + this.length() + " but got " + n2);
            }
            CharacterData characterData = (CharacterData)element.getFirstChild();
            String string = characterData.getData();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList arrayList = new ArrayList(this.length());
            SymbolParser symbolParser = this.alphabet.getParser("token");
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.addAll(symbolParser.parse(stringTokenizer.nextToken()).toList());
            }
            return new SimpleSymbolList(this.alphabet, arrayList);
        }
        catch (SAXException sAXException) {
            throw new BioError(sAXException, "Exception parsing DAS XML");
        }
        catch (IOException iOException) {
            throw new BioError(iOException, "Error connecting to DAS server");
        }
        catch (NumberFormatException numberFormatException) {
            throw new BioError(numberFormatException);
        }
        catch (BioException bioException) {
            throw new BioError(bioException);
        }
    }

    public String getURN() {
        try {
            return new URL(this.dataSourceURL, "?ref=" + this.seqID).toString();
        }
        catch (MalformedURLException malformedURLException) {
            throw new BioError(malformedURLException);
        }
    }

    public Iterator iterator() {
        try {
            return this.getSymbols().iterator();
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't iterate over symbols");
        }
    }

    public int length() {
        try {
            if (this.length < 0) {
                this.length = this.getSymbols().length();
            }
            return this.length;
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't calculate length");
        }
    }

    static DOMParser nonvalidatingParser() {
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        return dOMParser;
    }

    public Feature realizeFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException {
        return this.featureRealizer.realizeFeature(this, featureHolder, template);
    }

    void registerFeatureFetchers() throws BioException {
        this.registerLocalFeatureFetchers();
        FeatureHolder featureHolder = this.getStructure();
        if (this.length() < 1000000) {
            Iterator iterator = featureHolder.features();
            while (iterator.hasNext()) {
                ComponentFeature componentFeature = (ComponentFeature)iterator.next();
                DASSequence dASSequence = (DASSequence)componentFeature.getComponentSequence();
                dASSequence.registerFeatureFetchers();
            }
        }
    }

    void registerFeatureFetchers(Location location) throws BioException {
        this.registerLocalFeatureFetchers();
        FeatureHolder featureHolder = this.getStructure();
        if (featureHolder.countFeatures() > 0 && location.getMax() - location.getMin() < 1000000) {
            FeatureHolder featureHolder2 = featureHolder.filter(new FeatureFilter.OverlapsLocation(location), false);
            Iterator iterator = featureHolder2.features();
            while (iterator.hasNext()) {
                ComponentFeature componentFeature = (ComponentFeature)iterator.next();
                DASSequence dASSequence = (DASSequence)componentFeature.getComponentSequence();
                if (location.contains(componentFeature.getLocation())) {
                    dASSequence.registerFeatureFetchers();
                    continue;
                }
                Location location2 = location.intersection(componentFeature.getLocation());
                if (componentFeature.getStrand() == StrandedFeature.POSITIVE) {
                    location2 = location2.translate(componentFeature.getComponentLocation().getMin() - componentFeature.getLocation().getMin());
                    dASSequence.registerFeatureFetchers(location2);
                    continue;
                }
                dASSequence.registerFeatureFetchers();
            }
        }
    }

    private void registerLocalFeatureFetchers() {
        Iterator iterator = this.featureSets.values().iterator();
        while (iterator.hasNext()) {
            DASFeatureSet dASFeatureSet = (DASFeatureSet)iterator.next();
            dASFeatureSet.registerFeatureFetcher();
        }
    }

    public void removeAnnotationSource(URL uRL) throws ChangeVetoException, BioException {
        if (this.changeSupport == null) {
            this._removeAnnotationSource(uRL);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, ANNOTATIONS, null, null);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this._removeAnnotationSource(uRL);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    public String seqString() {
        try {
            return this.getSymbols().seqString();
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't create seqString");
        }
    }

    public SymbolList subList(int n, int n2) {
        try {
            return this.getSymbols().subList(n, n2);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't create subList");
        }
    }

    public String subStr(int n, int n2) {
        try {
            return this.getSymbols().subStr(n, n2);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't create substring");
        }
    }

    public Symbol symbolAt(int n) {
        try {
            return this.getSymbols().symbolAt(n);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't fetch symbol");
        }
    }

    public List toList() {
        try {
            return this.getSymbols().toList();
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Can't create list");
        }
    }

    private class SkeletonListener
    extends SeqIOAdapter {
        SkeletonListener() {
        }

        public void addSequenceProperty(Object object, Object object2) throws ParseException {
            try {
                if (object.equals("sequence.start")) {
                    int n = Integer.parseInt(object2.toString());
                    if (n != 1) {
                        throw new ParseException("Server doesn't think sequence starts at 1.  Wierd.");
                    }
                } else if (object.equals("sequence.stop")) {
                    DASSequence.this.length = Integer.parseInt(object2.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException, "Expect numbers for segment start and stop");
            }
        }

        public void startFeature(Feature.Template template) throws ParseException {
            if (template instanceof ComponentFeature.Template) {
                String string = (String)template.annotation.getProperty("sequence.id");
                try {
                    ComponentFeature.Template template2 = (ComponentFeature.Template)template;
                    DASComponentFeature dASComponentFeature = new DASComponentFeature(DASSequence.this, template2);
                    ((SimpleFeatureHolder)DASSequence.this.structure).addFeature(dASComponentFeature);
                    DASSequence.this.length = Math.max(DASSequence.this.length, template2.location.getMax());
                }
                catch (BioException bioException) {
                    throw new ParseException(bioException, "Error instantiating DASComponent");
                }
                catch (ChangeVetoException changeVetoException) {
                    throw new BioError(changeVetoException, "Immutable FeatureHolder when trying to build structure");
                }
            }
        }
    }
}

