/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.symbol.SymbolList;

public class SequencePanel
extends JComponent
implements SwingConstants,
SequenceRenderContext {
    private SymbolList sequence;
    private int direction = 0;
    private double scale = 12.0;
    private int lines = 1;
    private int spacer = 0;
    private double alongDim = 0.0;
    private double acrossDim = 0.0;
    private double lineDepth = 0.0;
    private int realLines = 0;
    private SequenceRenderContext.Border leadingBorder;
    private SequenceRenderContext.Border trailingBorder;
    private List views = new ArrayList();
    private Map depths = new HashMap();
    private RendererMonitor theMonitor = new RendererMonitor();
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;

    public SequencePanel() {
        this.leadingBorder = new SequenceRenderContext.Border();
        this.trailingBorder = new SequenceRenderContext.Border();
        this.leadingBorder.addPropertyChangeListener(this.theMonitor);
        this.trailingBorder.addPropertyChangeListener(this.theMonitor);
        if (this.getFont() == null) {
            this.setFont(new Font("Times New Roman", 0, 12));
        }
        this.addPropertyChangeListener(this.theMonitor);
    }

    public void addRenderer(SequenceRenderer sequenceRenderer) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(sequenceRenderer.getClass());
            EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
            int n = 0;
            while (n < eventSetDescriptorArray.length) {
                if (eventSetDescriptorArray[n].getListenerType() == (class$java$beans$PropertyChangeListener != null ? class$java$beans$PropertyChangeListener : SequencePanel.class$("java.beans.PropertyChangeListener"))) {
                    Method method = eventSetDescriptorArray[n].getAddListenerMethod();
                    Object[] objectArray = new Object[]{this.theMonitor};
                    method.invoke((Object)sequenceRenderer, objectArray);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.views.add(sequenceRenderer);
        this.resizeAndValidate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public SequenceRenderContext.Border getLeadingBorder() {
        return this.leadingBorder;
    }

    public int getLines() {
        return this.lines;
    }

    public double getScale() {
        return this.scale;
    }

    public SymbolList getSequence() {
        return this.sequence;
    }

    public int getSpacer() {
        return this.spacer;
    }

    public SequenceRenderContext.Border getTrailingBorder() {
        return this.trailingBorder;
    }

    public int graphicsToSequence(double d) {
        return (int)(d / this.scale) + 1;
    }

    public void paintComponent(Graphics graphics) {
        if (this.sequence == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (this.direction == 0) {
            double_.width = this.alongDim + this.leadingBorder.getSize() + this.trailingBorder.getSize();
            double_.height = this.acrossDim;
        } else {
            double_.width = this.acrossDim;
            double_.height = this.alongDim + this.leadingBorder.getSize() + this.trailingBorder.getSize();
        }
        Rectangle2D rectangle2D = graphics2D.getClip().getBounds2D();
        int n = 0;
        int n2 = this.realLines;
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        Rectangle2D.Double double_3 = new Rectangle2D.Double();
        double d = this.leadingBorder.getSize() + this.trailingBorder.getSize() + this.scale * (double)this.sequence.length();
        double d2 = this.lineDepth + (double)this.spacer;
        if (this.direction == 0) {
            double_2.width = d;
            double_3.width = this.alongDim;
            n = (int)Math.max((double)n, Math.floor(rectangle2D.getMinY() / d2));
            n2 = (int)Math.min((double)n2, Math.ceil(rectangle2D.getMaxY() / d2));
            graphics2D.translate((double)(-n) * this.alongDim + this.leadingBorder.getSize(), (double)n * d2);
        } else {
            double_2.height = d;
            double_3.height = this.alongDim;
            n = (int)Math.max((double)n, Math.floor(rectangle2D.getMinX() / d2));
            n2 = (int)Math.min((double)n2, Math.ceil(rectangle2D.getMaxX() / d2));
            graphics2D.translate((double)n * d2, (double)(-n) * this.alongDim + this.leadingBorder.getSize());
        }
        int n3 = n;
        while (n3 < n2) {
            if (this.direction == 0) {
                double_2.x = (double)n3 * this.alongDim - this.leadingBorder.getSize();
                double_3.x = (double)n3 * this.alongDim;
                double_2.y = 0.0;
            } else {
                double_2.x = 0.0;
                double_2.y = (double)n3 * this.alongDim - this.leadingBorder.getSize();
                double_3.y = (double)n3 * this.alongDim;
            }
            Iterator iterator = this.views.iterator();
            while (iterator.hasNext()) {
                SequenceRenderer sequenceRenderer = (SequenceRenderer)iterator.next();
                double d3 = (Double)this.depths.get(sequenceRenderer);
                if (this.direction == 0) {
                    double_2.height = d3;
                    double_3.height = d3;
                } else {
                    double_2.width = d3;
                    double_3.width = d3;
                }
                Shape shape = graphics2D.getClip();
                graphics2D.clip(double_2);
                sequenceRenderer.paint(graphics2D, this, double_3);
                graphics2D.setClip(shape);
                if (this.direction == 0) {
                    graphics2D.translate(0.0, d3);
                    continue;
                }
                graphics2D.translate(d3, 0.0);
            }
            if (this.direction == 0) {
                graphics2D.translate(-this.alongDim, (double)this.spacer);
            } else {
                graphics2D.translate((double)this.spacer, -this.alongDim);
            }
            ++n3;
        }
    }

    public void resizeAndValidate() {
        Object object;
        this.alongDim = this.sequence == null ? 0.0 : this.scale * (double)this.sequence.length();
        this.acrossDim = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.views.iterator();
        while (iterator.hasNext()) {
            object = (SequenceRenderer)iterator.next();
            double d3 = object.getDepth((SequenceRenderContext)this);
            this.depths.put(object, new Double(d3));
            this.acrossDim += d3;
            d = Math.max(d, object.getMinimumLeader((SequenceRenderContext)this));
            d2 = Math.max(d2, object.getMinimumTrailer((SequenceRenderContext)this));
        }
        this.lineDepth = this.acrossDim;
        this.leadingBorder.setSize(d);
        this.trailingBorder.setSize(d2);
        object = null;
        if (this.lines < 1) {
            Dimension dimension = this.getParent() != null ? this.getParent().getSize() : new Dimension();
            int n = 0;
            n = this.direction == 0 ? dimension.width : dimension.height;
            n = (int)Math.ceil(Math.ceil((double)n / this.scale) * this.scale);
            n = (int)Math.ceil((double)n - d - d2);
            this.realLines = (int)Math.ceil(this.alongDim / (double)n);
            this.acrossDim = this.acrossDim * (double)this.realLines + (double)(this.spacer * (this.realLines - 1));
            this.alongDim = Math.ceil(n);
            object = this.direction == 0 ? new Dimension((int)Math.ceil(this.alongDim + d + d2), (int)this.acrossDim) : new Dimension((int)this.acrossDim, (int)Math.ceil(this.alongDim + d + d2));
        } else {
            this.realLines = this.lines;
            this.alongDim = Math.ceil(this.alongDim / (double)this.lines);
            this.alongDim = Math.ceil(Math.ceil(this.alongDim / this.scale) * this.scale);
            this.acrossDim = Math.ceil((double)this.lines * this.acrossDim + (double)(this.lines - 1) * (double)this.spacer);
            object = this.direction == 0 ? new Dimension((int)Math.ceil(this.alongDim + d + d2), (int)this.acrossDim) : new Dimension((int)this.acrossDim, (int)Math.ceil(this.alongDim + d + d2));
        }
        this.setMinimumSize((Dimension)object);
        this.setPreferredSize((Dimension)object);
        this.revalidate();
    }

    public double sequenceToGraphics(int n) {
        return (double)(n - 1) * this.scale;
    }

    public void setDirection(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Direction must be either HORIZONTAL or VERTICAL");
        }
        int n2 = this.direction;
        this.direction = n;
        this.resizeAndValidate();
        this.firePropertyChange("direction", n2, this.direction);
    }

    public void setLines(int n) {
        int n2 = this.lines;
        this.lines = n;
        this.resizeAndValidate();
        this.firePropertyChange("lines", n2, n);
    }

    public void setScale(double d) {
        double d2 = this.scale;
        this.scale = d;
        this.resizeAndValidate();
        this.firePropertyChange("scale", d2, d);
    }

    public void setSequence(SymbolList symbolList) {
        SymbolList symbolList2 = this.sequence;
        this.sequence = symbolList;
        this.resizeAndValidate();
        this.firePropertyChange("sequence", symbolList2, symbolList);
    }

    public void setSpacer(int n) {
        int n2 = this.spacer;
        this.spacer = n;
        this.resizeAndValidate();
        this.firePropertyChange("spacer", n2, n);
    }

    private class RendererMonitor
    implements PropertyChangeListener {
        RendererMonitor() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            SequencePanel.this.repaint();
        }
    }

    public class Border
    implements Serializable,
    SwingConstants {
        protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private double size = 0.0;
        private int alignment = 0;

        private Border() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public int getAlignment() {
            return this.alignment;
        }

        public double getSize() {
            return this.size;
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        public void setAlignment(int n) throws IllegalArgumentException {
            if (n != 10 && n != 11 && n != 0) {
                throw new IllegalArgumentException("Alignment must be one of the constants LEADING, TRAILING or CENTER");
            }
            int n2 = this.alignment;
            this.alignment = n;
            this.pcs.firePropertyChange("alignment", n2, n);
        }

        private void setSize(double d) {
            this.size = d;
        }
    }
}

