/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.io.Serializable;
import org.biojava.bio.dist.AbstractDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.utils.ChangeVetoException;

public class UniformDistribution
extends AbstractDistribution
implements Serializable {
    private final FiniteAlphabet alphabet;
    private Distribution nullModel;

    public UniformDistribution(FiniteAlphabet finiteAlphabet) {
        this.alphabet = finiteAlphabet;
        this.nullModel = this;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Distribution getNullModel() {
        return this.nullModel;
    }

    protected double getWeightImpl(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        return 1.0 / (double)this.alphabet.size();
    }

    public void registerWithTrainer(DistributionTrainerContext distributionTrainerContext) {
        distributionTrainerContext.registerTrainer(this, IgnoreCountsTrainer.getInstance());
    }

    protected void setNullModelImpl(Distribution distribution) throws IllegalAlphabetException {
        this.nullModel = distribution;
    }

    protected void setWeightImpl(AtomicSymbol atomicSymbol, double d) throws ChangeVetoException {
        throw new ChangeVetoException("Can't change the weights in a UniformDistribution");
    }
}

