/*
 * Decompiled with CFR 0.152.
 */
package org.acedb;

import java.net.URL;
import org.acedb.AceURLException;

public class AceURL {
    private String authority;
    private String userInfo;
    private String file;
    private String host;
    private int port;
    private String protocol;
    private String query;
    private String ref;

    public AceURL(String string) throws AceURLException {
        int n;
        int n2 = string.indexOf(58);
        if (n2 == -1) {
            throw new AceURLException("No protocol");
        }
        this.protocol = string.substring(0, n2);
        int n3 = string.indexOf("//");
        String string2 = null;
        if (n3 == -1) {
            string2 = string.substring(n2 + 1);
        } else {
            String string3 = null;
            n = string.indexOf(47, n3 + 2);
            if (n != -1) {
                string2 = string.substring(n);
                string3 = string.substring(n3 + 2, n);
            } else {
                string3 = string.substring(n3 + 2);
            }
            int n4 = string3.indexOf(64);
            if (n4 != -1) {
                String string4 = string3.substring(0, n4);
                n2 = string4.indexOf(58);
                if (n2 == -1) {
                    this.userInfo = string4;
                } else {
                    this.userInfo = string4.substring(0, n2);
                    this.authority = string4.substring(n2 + 1);
                }
                string3 = string3.substring(n4 + 1);
            }
            if ((n2 = string3.indexOf(58)) == -1) {
                this.host = string3;
            } else {
                this.host = string3.substring(0, n2);
                try {
                    this.port = Integer.parseInt(string3.substring(n2 + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new AceURLException(numberFormatException, "Bad port number");
                }
            }
        }
        if (string2 != null) {
            int n5 = string2.indexOf(35);
            if (n5 != -1) {
                this.ref = string2.substring(n5 + 1);
                string2 = string2.substring(0, n5);
            }
            if ((n = string2.indexOf(63)) == -1) {
                this.file = string2;
            } else {
                this.query = string2.substring(n + 1);
                this.file = string2.substring(0, n);
            }
        }
    }

    public AceURL(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        this.file = string3;
        this.query = string4;
        this.ref = string5;
        this.userInfo = string6;
        this.authority = string7;
    }

    public AceURL(URL uRL, String string, String string2, String string3) {
        this.protocol = uRL.getProtocol();
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        this.file = uRL.getFile();
        this.query = string3;
        this.ref = uRL.getRef();
        this.userInfo = string;
        this.authority = string2;
        while (this.file.startsWith("/")) {
            this.file = this.file.substring(1);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AceURL)) {
            return false;
        }
        AceURL aceURL = (AceURL)object;
        if (!this.streq(aceURL.getProtocol(), this.protocol)) {
            return false;
        }
        if (!this.streq(aceURL.getHost(), this.host)) {
            return false;
        }
        if (aceURL.getPort() != this.port) {
            return false;
        }
        if (!this.streq(aceURL.getFile(), this.file)) {
            return false;
        }
        if (!this.streq(aceURL.getQuery(), this.query)) {
            return false;
        }
        if (!this.streq(aceURL.getRef(), this.ref)) {
            return false;
        }
        if (!this.streq(aceURL.getUserInfo(), this.userInfo)) {
            return false;
        }
        return this.streq(aceURL.getAuthority(), this.authority);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFile() {
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        System.out.println("Fixme AceURL.getPath()");
        return this.file;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public AceURL relativeURL(String string) {
        int n = string.indexOf(35);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        int n2 = string.indexOf(63);
        String string3 = null;
        if (n2 != -1) {
            string3 = string.substring(n2 + 1);
            string = string.substring(0, n2);
        }
        return new AceURL(this.protocol, this.host, this.port, this.file == null || string.startsWith("/") ? string : String.valueOf(this.file) + "/" + string, string3, string2, this.userInfo, this.authority);
    }

    private boolean streq(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.protocol);
        stringBuffer.append("://");
        if (this.userInfo != null) {
            stringBuffer.append(this.userInfo);
            if (this.authority != null) {
                stringBuffer.append(':');
                stringBuffer.append(this.authority);
            }
            stringBuffer.append('@');
        }
        stringBuffer.append(this.host);
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        if (this.file != null) {
            stringBuffer.append('/');
            stringBuffer.append(this.file);
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        if (this.ref != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.ref);
        }
        return stringBuffer.toString();
    }
}

