/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.SequenceContext;
import eponine.model.BundleConstraint;
import eponine.model.Constraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.SymbolList;
import stats.glm.BasisFunction;
import stats.glm.GLMClassificationModel;

public class FastModel {
    private double[][] cache;
    private int cacheWidth;
    private int maxSeen;
    private SymbolList seq;
    private SequenceContext sc;
    private int numConstraints = 0;
    private BasisFunction[] bases;
    private double[] weights;

    public FastModel(GLMClassificationModel gLMClassificationModel, SymbolList symbolList, int n) {
        this.seq = symbolList;
        this.sc = new SequenceContext(symbolList, 0);
        this.cacheWidth = n;
        Collection collection = gLMClassificationModel.getBasisFunctions();
        this.bases = new BasisFunction[collection.size()];
        this.weights = new double[collection.size()];
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            BasisFunction basisFunction = ModelTools.removeHistory((BasisFunction)iterator.next());
            this.bases[n2] = basisFunction instanceof ConstraintBasisFunction ? new ConstraintBasisFunction(this.wrapConstraint(((ConstraintBasisFunction)basisFunction).getConstraint())) : basisFunction;
            this.weights[n2] = gLMClassificationModel.getWeight(basisFunction);
            ++n2;
        }
        this.cache = new double[this.numConstraints][this.cacheWidth];
        this.maxSeen = 0;
        n2 = 0;
        while (n2 < this.cacheWidth) {
            int n3 = 0;
            while (n3 < this.numConstraints) {
                this.cache[n3][n2] = Double.NaN;
                ++n3;
            }
            ++n2;
        }
    }

    public double score(int n) {
        double d = 0.0;
        this.sc.setPosition(n);
        int n2 = 0;
        while (n2 < this.bases.length) {
            d += this.weights[n2] * this.bases[n2].evaluate(this.sc);
            ++n2;
        }
        return this.logit(d);
    }

    private double logit(double d) {
        return 1.0 / (1.0 + Math.exp(-d));
    }

    private void setMaxSeen(int n) {
        int n2 = this.maxSeen + 1;
        while (n2 <= n) {
            int n3 = n2 % this.cacheWidth;
            int n4 = 0;
            while (n4 < this.numConstraints) {
                this.cache[n4][n3] = Double.NaN;
                ++n4;
            }
            ++n2;
        }
        this.maxSeen = n;
    }

    private Constraint wrapConstraint(Constraint constraint) {
        if (constraint instanceof PositionedConstraint) {
            PositionedConstraint positionedConstraint = (PositionedConstraint)constraint;
            Constraint constraint2 = this.wrapConstraint(positionedConstraint.getConstraint());
            return new WrappedConstraint(new PositionedConstraint(constraint2, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum()));
        }
        if (constraint instanceof BundleConstraint) {
            List list = ((BundleConstraint)constraint).getConstraints();
            ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.wrapConstraint((Constraint)iterator.next()));
            }
            return new BundleConstraint(arrayList);
        }
        return new WrappedConstraint(constraint);
    }

    private class WrappedConstraint
    implements Constraint {
        private int num;
        private Constraint cons;

        WrappedConstraint(Constraint constraint) {
            this.cons = constraint;
            this.num = FastModel.this.numConstraints++;
        }

        public double evaluate(SymbolList symbolList, int n) {
            if (n > FastModel.this.maxSeen) {
                FastModel.this.setMaxSeen(n);
            }
            while (n < 0) {
                n += FastModel.this.cacheWidth;
            }
            int n2 = n % FastModel.this.cacheWidth;
            double d = FastModel.this.cache[this.num][n2];
            if (Double.isNaN(d)) {
                ((FastModel)FastModel.this).cache[this.num][n2] = d = this.cons.evaluate(symbolList, n);
            }
            return d;
        }

        public double nullModel(SymbolList symbolList, int n) {
            return this.cons.nullModel(symbolList, n);
        }

        public double divisor() {
            return this.cons.divisor();
        }
    }
}

