/*
 * Decompiled with CFR 0.152.
 */
package eponine.datasource;

import eponine.SequenceContext;
import eponine.datasource.DataSource;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.io.FastaDescriptionLineParser;
import org.biojava.bio.seq.io.SequenceBuilderFactory;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamReader;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.stats.svm.SVMTarget;
import org.biojava.stats.svm.SimpleSVMTarget;
import org.biojava.utils.xml.Initializable;

public class FileDataSource
implements DataSource,
Initializable {
    private SVMTarget trainingExamples;
    private SVMTarget testExamples;
    private String positivesFile;
    private String negativesFile;
    private SequenceFormat positivesFormat;
    private SequenceFormat negativesFormat;
    private double negativeMultiplier = 1.0;
    private int numTestExamples = 20;
    private int anchorPoint;

    public void setPositivesFile(String string) {
        this.positivesFile = string;
    }

    public void setNegativesFile(String string) {
        this.negativesFile = string;
    }

    public void setPositivesFormat(SequenceFormat sequenceFormat) {
        this.positivesFormat = sequenceFormat;
    }

    public void setNegativesFormat(SequenceFormat sequenceFormat) {
        this.negativesFormat = sequenceFormat;
    }

    public void setNegativeMultiplier(double d) {
        this.negativeMultiplier = d;
    }

    public void setNumTestExamples(int n) {
        this.numTestExamples = n;
    }

    public void setAnchorPoint(int n) {
        this.anchorPoint = n;
    }

    public SVMTarget getTrainingExamples() {
        return this.trainingExamples;
    }

    public SVMTarget getTestExamples() {
        return this.testExamples;
    }

    public void init() {
        this.trainingExamples = new SimpleSVMTarget();
        this.testExamples = new SimpleSVMTarget();
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            FastaDescriptionLineParser.Factory factory = new FastaDescriptionLineParser.Factory(SimpleSequenceBuilder.FACTORY);
            System.out.println("Positive examples:");
            ArrayList<SequenceContext> arrayList = new ArrayList<SequenceContext>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.positivesFile));
            StreamReader streamReader = new StreamReader(bufferedReader, this.positivesFormat, DNATools.getDNA().getParser("token"), (SequenceBuilderFactory)factory);
            while (streamReader.hasNext()) {
                object3 = streamReader.nextSequence();
                if (!this.checkSequence((SymbolList)object3)) continue;
                object2 = new SequenceContext((SymbolList)object3, this.anchorPoint);
                arrayList.add((SequenceContext)object2);
            }
            bufferedReader.close();
            System.out.println("Number of positives accepted: " + arrayList.size());
            System.out.println("Negative examples:");
            object3 = new ArrayList();
            bufferedReader = new BufferedReader(new FileReader(this.negativesFile));
            streamReader = new StreamReader(bufferedReader, this.negativesFormat, DNATools.getDNA().getParser("token"), (SequenceBuilderFactory)factory);
            object2 = streamReader.nextSequence();
            int n2 = (int)Math.floor((double)(arrayList.size() - this.numTestExamples) * this.negativeMultiplier) + this.numTestExamples;
            while (object3.size() < n2) {
                n = (int)Math.floor(Math.random() * (double)(object2.length() - 20000)) + 10000;
                object = object2.subList(n - 500, n + 100);
                if (!this.checkSequence((SymbolList)object)) continue;
                object3.add(new SequenceContext((SymbolList)object, this.anchorPoint));
            }
            n = 0;
            while (n < this.numTestExamples) {
                int n3 = (int)Math.floor(Math.random() * (double)arrayList.size());
                this.testExamples.addItemTarget(arrayList.remove(n3), 1.0);
                ++n;
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                this.trainingExamples.addItemTarget(object.next(), 1.0);
            }
            int n4 = 0;
            while (n4 < this.numTestExamples) {
                int n5 = (int)Math.floor(Math.random() * (double)object3.size());
                this.testExamples.addItemTarget(object3.remove(n5), 0.0);
                ++n4;
            }
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                this.trainingExamples.addItemTarget(iterator.next(), 0.0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new BioError(exception);
        }
    }

    private boolean checkSequence(SymbolList symbolList) throws BioException {
        Symbol symbol = DNATools.getDNA().getParser("token").parseToken("N");
        int n = 0;
        Iterator iterator = symbolList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(symbol)) break;
            ++n;
        }
        System.out.println(n);
        return n < 5;
    }
}

