/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import java.io.IOException;
import java.io.PrintWriter;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLPrettyPrinter
implements DocumentHandler {
    private PrintWriter writer;
    private int indent = 0;
    private int indentUnit = 2;
    private boolean afterElementStart = false;

    private void doIndent() throws IOException {
        int n = 0;
        while (n < this.indent) {
            this.writer.print(' ');
            ++n;
        }
    }

    public XMLPrettyPrinter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void startDocument() {
        this.writer.println("<?xml version=\"1.0\" ?>");
    }

    public void endDocument() {
        this.writer.close();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this.afterElementStart) {
                this.writer.println(">");
            }
            this.doIndent();
            this.writer.print("<" + string);
            int n = 0;
            while (n < attributeList.getLength()) {
                this.writer.print(" " + attributeList.getName(n) + "=\"" + attributeList.getValue(n) + "\"");
                ++n;
            }
            this.indent += this.indentUnit;
            this.afterElementStart = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        try {
            this.indent -= this.indentUnit;
            if (this.afterElementStart) {
                this.writer.println(" />");
                this.afterElementStart = false;
            } else {
                this.doIndent();
                this.writer.println("</" + string + ">");
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.afterElementStart) {
            this.writer.println(">");
            this.afterElementStart = false;
        }
        this.writer.write(cArray, n, n2);
        this.writer.println();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        throw new SAXException("Can't handled processing instructions");
    }

    public void setDocumentLocator(Locator locator) {
    }
}

