/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import java.util.Date;

public class Ranlux
extends RandomSeedable {
    public static final int maxlev = 4;
    public static final int lxdflt = 3;
    static final int igiga = 1000000000;
    static final int jsdflt = 314159265;
    static final int twop12 = 4096;
    static final int itwo24 = 0x1000000;
    static final int icons = 2147483563;
    static final int[] ndskip = new int[]{0, 24, 73, 199, 365};
    int[] iseeds;
    int[] isdext;
    int[] next;
    int luxlev = 3;
    int nskip;
    int inseed;
    int jseed;
    int in24 = 0;
    int kount = 0;
    int mkount = 0;
    int i24 = 24;
    int j24 = 10;
    float[] seeds;
    float carry = 0.0f;
    float twom24;
    float twom12;
    boolean diagOn = false;

    public Ranlux() {
        this.init_arrays();
        this.rluxdef();
    }

    public Ranlux(int n) {
        this.init_arrays();
        this.rluxgo(3, Math.abs(n));
    }

    public Ranlux(int n, int n2) {
        this.init_arrays();
        this.rluxgo(n, Math.abs(n2));
    }

    public Ranlux(int n, long l) {
        this.init_arrays();
        this.rluxgo(n, Math.abs((int)(l % Integer.MAX_VALUE)));
    }

    public Ranlux(int n, Date date) {
        this.init_arrays();
        this.rluxgo(n, (int)(RandomSeedable.ClockSeed(date) % Integer.MAX_VALUE));
    }

    public Ranlux(long l) {
        this.init_arrays();
        this.rluxgo(3, Math.abs((int)(l % Integer.MAX_VALUE)));
    }

    public Ranlux(Date date) {
        this.init_arrays();
        this.rluxgo(3, (int)(RandomSeedable.ClockSeed(date) % Integer.MAX_VALUE));
    }

    public Object clone() {
        Ranlux ranlux = (Ranlux)super.clone();
        ranlux.iseeds = (int[])this.iseeds.clone();
        ranlux.isdext = (int[])this.isdext.clone();
        ranlux.next = (int[])this.next.clone();
        ranlux.seeds = (float[])this.seeds.clone();
        return ranlux;
    }

    private void diag(String string) {
        if (this.diagOn) {
            System.err.println(string);
        }
    }

    private void init_arrays() {
        this.iseeds = new int[25];
        this.isdext = new int[26];
        this.next = new int[25];
        this.seeds = new float[25];
    }

    public final double raw() {
        float f = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
        if (f < 0.0f) {
            f += 1.0f;
            this.carry = this.twom24;
        } else {
            this.carry = 0.0f;
        }
        this.seeds[this.i24] = f;
        this.i24 = this.next[this.i24];
        this.j24 = this.next[this.j24];
        float f2 = f;
        if (f < this.twom12) {
            f2 += this.twom24 * this.seeds[this.j24];
        }
        if ((double)f2 == 0.0) {
            f2 = this.twom24 * this.twom24;
        }
        ++this.in24;
        if (this.in24 == 24) {
            this.in24 = 0;
            this.kount += this.nskip;
            int n = 1;
            while (n <= this.nskip) {
                f = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
                if (f < 0.0f) {
                    f += 1.0f;
                    this.carry = this.twom24;
                } else {
                    this.carry = 0.0f;
                }
                this.seeds[this.i24] = f;
                this.i24 = this.next[this.i24];
                this.j24 = this.next[this.j24];
                ++n;
            }
        }
        ++this.kount;
        if (this.kount >= 1000000000) {
            ++this.mkount;
            this.kount -= 1000000000;
        }
        return f2;
    }

    private void rluxdef() {
        this.inseed = this.jseed = 314159265;
        this.diag("RANLUX DEFAULT INITIALIZATION: " + this.jseed);
        this.luxlev = 3;
        this.nskip = ndskip[this.luxlev];
        int n = this.nskip + 24;
        this.in24 = 0;
        this.kount = 0;
        this.mkount = 0;
        this.diag("RANLUX DEFAULT LUXURY LEVEL =  " + this.luxlev + "    p = " + n);
        this.twom24 = 1.0f;
        int n2 = 1;
        while (n2 <= 24) {
            this.twom24 *= 0.5f;
            int n3 = this.jseed / 53668;
            this.jseed = 40014 * (this.jseed - n3 * 53668) - n3 * 12211;
            if (this.jseed < 0) {
                this.jseed += 2147483563;
            }
            this.iseeds[n2] = this.jseed % 0x1000000;
            ++n2;
        }
        this.twom12 = this.twom24 * 4096.0f;
        n2 = 1;
        while (n2 <= 24) {
            this.seeds[n2] = (float)this.iseeds[n2] * this.twom24;
            this.next[n2] = n2 - 1;
            ++n2;
        }
        this.next[1] = 24;
        this.i24 = 24;
        this.j24 = 10;
        this.carry = 0.0f;
        if ((double)this.seeds[24] == 0.0) {
            this.carry = this.twom24;
        }
    }

    private final void rluxgo(int n, int n2) {
        if (n < 0) {
            this.luxlev = 3;
        } else if (n <= 4) {
            this.luxlev = n;
        } else if (n < 24 || n > 2000) {
            this.luxlev = 4;
            this.diag("RANLUX ILLEGAL LUXURY RLUXGO: " + n);
        } else {
            this.luxlev = n;
            int n3 = 0;
            while (n3 <= 4) {
                if (n == ndskip[n3] + 24) {
                    this.luxlev = n3;
                }
                ++n3;
            }
        }
        if (this.luxlev <= 4) {
            this.nskip = ndskip[this.luxlev];
            this.diag("RANLUX LUXURY LEVEL SET BY RLUXGO : " + this.luxlev + " P= " + (this.nskip + 24));
        } else {
            this.nskip = this.luxlev - 24;
            this.diag("RANLUX P-VALUE SET BY RLUXGO TO: " + this.luxlev);
        }
        this.in24 = 0;
        if (n2 < 0) {
            this.diag("Illegal initialization by RLUXGO, negative input seed");
        }
        if (n2 > 0) {
            this.jseed = n2;
            this.diag("RANLUX INITIALIZED BY RLUXGO FROM SEED " + this.jseed);
        } else {
            this.jseed = 314159265;
            this.diag("RANLUX INITIALIZED BY RLUXGO FROM DEFAULT SEED");
        }
        this.inseed = this.jseed;
        this.twom24 = 1.0f;
        int n4 = 1;
        while (n4 <= 24) {
            this.twom24 *= 0.5f;
            int n5 = this.jseed / 53668;
            this.jseed = 40014 * (this.jseed - n5 * 53668) - n5 * 12211;
            if (this.jseed < 0) {
                this.jseed += 2147483563;
            }
            this.iseeds[n4] = this.jseed % 0x1000000;
            ++n4;
        }
        this.twom12 = this.twom24 * 4096.0f;
        n4 = 1;
        while (n4 <= 24) {
            this.seeds[n4] = (float)this.iseeds[n4] * this.twom24;
            this.next[n4] = n4 - 1;
            ++n4;
        }
        this.next[1] = 24;
        this.i24 = 24;
        this.j24 = 10;
        this.carry = 0.0f;
        if ((double)this.seeds[24] == 0.0) {
            this.carry = this.twom24;
        }
        this.kount = 0;
        this.mkount = 0;
    }

    public void setDiag(boolean bl) {
        this.diagOn = bl;
    }
}

