/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix1D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;

public class DenseDoubleMatrix1D
extends DoubleMatrix1D {
    protected double[] elements;

    public DenseDoubleMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public DenseDoubleMatrix1D(int n) {
        this.setUp(n);
        this.elements = new double[n];
    }

    protected DenseDoubleMatrix1D(int n, double[] dArray, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = dArray;
        this.isNoView = false;
    }

    public DoubleMatrix1D assign(double[] dArray) {
        if (this.isNoView) {
            if (dArray.length != this.size) {
                throw new IllegalArgumentException("Must have same number of cells: length=" + dArray.length + "size()=" + this.size());
            }
            System.arraycopy(dArray, 0, this.elements, 0, dArray.length);
        } else {
            super.assign(dArray);
        }
        return this;
    }

    public DoubleMatrix1D assign(double d) {
        if (this.isNoView) {
            new DoubleArrayList(this.elements).fillFromToWith(0, this.elements.length - 1, d);
            return this;
        }
        int n = this.index(0);
        int n2 = this.stride;
        double[] dArray = this.elements;
        int n3 = this.size;
        while (--n3 >= 0) {
            dArray[n] = d;
            n += n2;
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleFunction doubleFunction) {
        int n = this.stride;
        int n2 = this.index(0);
        double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        if (doubleFunction instanceof Mult) {
            double d = ((Mult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            int n3 = this.size;
            while (--n3 >= 0) {
                int n4 = n2;
                dArray[n4] = dArray[n4] * d;
                n2 += n;
            }
        } else {
            int n5 = this.size;
            while (--n5 >= 0) {
                dArray[n2] = doubleFunction.apply(dArray[n2]);
                n2 += n;
            }
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D) {
        Object object;
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.assign(doubleMatrix1D);
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        if (denseDoubleMatrix1D == this) {
            return this;
        }
        this.checkSize(denseDoubleMatrix1D);
        if (this.isNoView && denseDoubleMatrix1D.isNoView) {
            System.arraycopy(denseDoubleMatrix1D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseDoubleMatrix1D)) {
            object = denseDoubleMatrix1D.copy();
            if (!(object instanceof DenseDoubleMatrix1D)) {
                return super.assign(doubleMatrix1D);
            }
            denseDoubleMatrix1D = (DenseDoubleMatrix1D)object;
        }
        object = this.elements;
        double[] dArray = denseDoubleMatrix1D.elements;
        if (this.elements == null || dArray == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseDoubleMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseDoubleMatrix1D.index(0);
        int n5 = this.size;
        while (--n5 >= 0) {
            object[n3] = dArray[n4];
            n3 += n;
            n4 += n2;
        }
        return this;
    }

    public DoubleMatrix1D assign(DoubleMatrix1D doubleMatrix1D, DoubleDoubleFunction doubleDoubleFunction) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.assign(doubleMatrix1D, doubleDoubleFunction);
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        this.checkSize(doubleMatrix1D);
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix1D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseDoubleMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseDoubleMatrix1D.index(0);
        if (doubleDoubleFunction == Functions.mult) {
            int n5 = this.size;
            while (--n5 >= 0) {
                int n6 = n3;
                dArray[n6] = dArray[n6] * dArray2[n4];
                n3 += n;
                n4 += n2;
            }
        } else if (doubleDoubleFunction == Functions.div) {
            int n7 = this.size;
            while (--n7 >= 0) {
                int n8 = n3;
                dArray[n8] = dArray[n8] / dArray2[n4];
                n3 += n;
                n4 += n2;
            }
        } else if (doubleDoubleFunction instanceof PlusMult) {
            double d = ((PlusMult)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            if (d == 1.0) {
                int n9 = this.size;
                while (--n9 >= 0) {
                    int n10 = n3;
                    dArray[n10] = dArray[n10] + dArray2[n4];
                    n3 += n;
                    n4 += n2;
                }
            } else if (d == -1.0) {
                int n11 = this.size;
                while (--n11 >= 0) {
                    int n12 = n3;
                    dArray[n12] = dArray[n12] - dArray2[n4];
                    n3 += n;
                    n4 += n2;
                }
            } else {
                int n13 = this.size;
                while (--n13 >= 0) {
                    int n14 = n3;
                    dArray[n14] = dArray[n14] + d * dArray2[n4];
                    n3 += n;
                    n4 += n2;
                }
            }
        } else {
            int n15 = this.size;
            while (--n15 >= 0) {
                dArray[n3] = doubleDoubleFunction.apply(dArray[n3], dArray2[n4]);
                n3 += n;
                n4 += n2;
            }
        }
        return this;
    }

    protected int cardinality(int n) {
        int n2 = 0;
        int n3 = this.index(0);
        int n4 = this.stride;
        double[] dArray = this.elements;
        int n5 = this.size;
        while (--n5 >= 0 && n2 < n) {
            if (dArray[n3] != 0.0) {
                ++n2;
            }
            n3 += n4;
        }
        return n2;
    }

    public double getQuick(int n) {
        return this.elements[this.zero + n * this.stride];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D instanceof SelectedDenseDoubleMatrix1D) {
            SelectedDenseDoubleMatrix1D selectedDenseDoubleMatrix1D = (SelectedDenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == selectedDenseDoubleMatrix1D.elements;
        }
        if (doubleMatrix1D instanceof DenseDoubleMatrix1D) {
            DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
            return this.elements == denseDoubleMatrix1D.elements;
        }
        return false;
    }

    protected int index(int n) {
        return this.zero + n * this.stride;
    }

    public DoubleMatrix1D like(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    public DoubleMatrix2D like2D(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public void setQuick(int n, double d) {
        this.elements[this.zero + n * this.stride] = d;
    }

    public void swap(DoubleMatrix1D doubleMatrix1D) {
        DenseDoubleMatrix1D denseDoubleMatrix1D;
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            super.swap(doubleMatrix1D);
        }
        if ((denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D) == this) {
            return;
        }
        this.checkSize(denseDoubleMatrix1D);
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix1D.elements;
        if (this.elements == null || dArray2 == null) {
            throw new InternalError();
        }
        int n = this.stride;
        int n2 = denseDoubleMatrix1D.stride;
        int n3 = this.index(0);
        int n4 = denseDoubleMatrix1D.index(0);
        int n5 = this.size;
        while (--n5 >= 0) {
            double d = dArray[n3];
            dArray[n3] = dArray2[n4];
            dArray2[n4] = d;
            n3 += n;
            n4 += n2;
        }
    }

    public void toArray(double[] dArray) {
        if (dArray.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, dArray, 0, this.elements.length);
        } else {
            super.toArray(dArray);
        }
    }

    protected DoubleMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseDoubleMatrix1D(this.elements, nArray);
    }

    public double zDotProduct(DoubleMatrix1D doubleMatrix1D, int n, int n2) {
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D)) {
            return super.zDotProduct(doubleMatrix1D, n, n2);
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        int n3 = n + n2;
        if (n < 0 || n2 < 0) {
            return 0.0;
        }
        if (this.size < n3) {
            n3 = this.size;
        }
        if (doubleMatrix1D.size < n3) {
            n3 = doubleMatrix1D.size;
        }
        int n4 = n3 - n;
        int n5 = this.index(n);
        int n6 = denseDoubleMatrix1D.index(n);
        int n7 = this.stride;
        int n8 = denseDoubleMatrix1D.stride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix1D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        double d = 0.0;
        n5 -= n7;
        n6 -= n8;
        int n9 = n4 / 4;
        while (--n9 >= 0) {
            int n10 = n5 + n7;
            n5 = n10;
            int n11 = n6 + n8;
            n6 = n11;
            int n12 = n5 + n7;
            n5 = n12;
            int n13 = n6 + n8;
            n6 = n13;
            n5 = n5 + n7;
            n6 = n6 + n8;
            d += dArray[n10] * dArray2[n11] + dArray[n12] * dArray2[n13] + dArray[n5] * dArray2[n6] + dArray[n5 += n7] * dArray2[n6 += n8];
        }
        int n14 = n4 % 4;
        while (--n14 >= 0) {
            d += dArray[n5 += n7] * dArray2[n6 += n8];
        }
        return d;
    }

    public double zSum() {
        double d = 0.0;
        int n = this.stride;
        int n2 = this.index(0);
        double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        int n3 = this.size;
        while (--n3 >= 0) {
            d += dArray[n2];
            n2 += n;
        }
        return d;
    }
}

