/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.doublealgo;

import cern.colt.Timer;
import cern.colt.list.ObjectArrayList;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.DoubleMatrix3D;
import cern.colt.matrix.ObjectFactory2D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.AbstractFormatter;
import cern.colt.matrix.impl.AbstractMatrix1D;
import cern.colt.matrix.impl.AbstractMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import corejava.Format;
import hep.aida.bin.BinFunction1D;
import hep.aida.bin.BinFunctions1D;

public class Formatter
extends AbstractFormatter {
    public Formatter() {
        this("%G");
    }

    public Formatter(String string) {
        this.setFormat(string);
        this.setAlignment("decimal");
    }

    public static void demo1() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"%G", "%1.10G", "%f", "%1.2f", "%0.2e", null};
        int n = stringArray.length;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(dArrayArray);
        String[] stringArray2 = new String[n];
        String[] stringArray3 = new String[n];
        String[] stringArray4 = new String[n];
        String[] stringArray5 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringArray2[n2] = new Formatter(string).toString(doubleMatrix2D);
            stringArray3[n2] = new Formatter(string).toSourceCode(doubleMatrix2D);
            ++n2;
        }
        System.out.println("original:\n" + new Formatter().toString(doubleMatrix2D));
        int n3 = 0;
        while (n3 < n) {
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            System.out.println("\nstring(" + stringArray[n4] + "):\n" + stringArray2[n4]);
            System.out.println("\nsourceCode(" + stringArray[n4] + "):\n" + stringArray3[n4]);
            ++n4;
        }
    }

    public static void demo2() {
        double[] dArray = new double[]{5.0, 0.0, -0.0, Double.NaN, Double.NaN, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        String[] stringArray = new String[]{"%G", "%1.19G"};
        int n = stringArray.length;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(dArray);
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            stringArray2[n2] = new Formatter(string).toString(denseDoubleMatrix1D);
            int n3 = 0;
            while (n3 < denseDoubleMatrix1D.size()) {
                System.out.println(String.valueOf(denseDoubleMatrix1D.get(n3)));
                ++n3;
            }
            ++n2;
        }
        System.out.println("original:\n" + new Formatter().toString(denseDoubleMatrix1D));
        int n4 = 0;
        while (n4 < n) {
            System.out.println("\nstring(" + stringArray[n4] + "):\n" + stringArray2[n4]);
            ++n4;
        }
    }

    public static void demo3(int n, double d) {
        Timer timer = new Timer();
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(n, n, d);
        timer.reset().start();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (--n2 >= 0) {
            int n3 = n;
            while (--n3 >= 0) {
                stringBuffer.append(doubleMatrix2D.getQuick(n2, n3));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        Format format = new Format("%G");
        stringBuffer = new StringBuffer();
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n;
            while (--n5 >= 0) {
                stringBuffer.append(format.form(doubleMatrix2D.getQuick(n4, n5)));
            }
        }
        stringBuffer = null;
        timer.stop().display();
        timer.reset().start();
        String string = new Formatter(null).toString(doubleMatrix2D);
        string = null;
        timer.stop().display();
        timer.reset().start();
        string = new Formatter("%G").toString(doubleMatrix2D);
        string = null;
        timer.stop().display();
    }

    public static void demo4() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.make(dArrayArray);
        System.out.println("\n\n" + new Formatter("%G").toTitleString(doubleMatrix2D, stringArray2, stringArray, "rowAxis", "colAxis", "VM Performance: Provider vs. matrix density"));
    }

    public static void demo5() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"0.1", "0.3", "0.5", "0.7"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(DoubleFactory2D.dense.make(dArrayArray));
        System.out.println(new Formatter("%G").toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo6() {
        double[][] dArrayArray = new double[][]{{3.0, 0.0, -3.4, 0.0}, {5.1, 0.0, 3.0123456789, 0.0}, {16.37, 0.0, 2.5, 0.0}, {-16.3, 0.0, -3.012345678E-4, -1.0}, {1236.3456789, 0.0, 7.0, -1.2}};
        String[] stringArray = new String[]{"W", "X", "Y", "Z"};
        String[] stringArray2 = new String[]{"SunJDK1.2.2 classic", "IBMJDK1.1.8", "SunJDK1.3 Hotspot", "other1", "other2"};
        System.out.println(new Formatter().toString(DoubleFactory2D.dense.make(dArrayArray)));
        System.out.println(new Formatter().toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, "vendor", "density", "title"));
    }

    public static void demo7() {
        double[][] dArrayArray = new double[][]{{5.0, 10.0, 20.0, 40.0}, {7.0, 8.0, 6.0, 7.0}, {12.0, 10.0, 20.0, 19.0}, {3.0, 1.0, 5.0, 6.0}};
        String[] stringArray = new String[]{"1996", "1997", "1998", "1999"};
        String[] stringArray2 = new String[]{"PowerBar", "Benzol", "Mercedes", "Sparcling"};
        String string = "CPU";
        String string2 = "Year";
        String string3 = "CPU performance over time [nops/sec]";
        BinFunctions1D binFunctions1D = BinFunctions1D.functions;
        BinFunction1D[] binFunction1DArray = new BinFunction1D[]{BinFunctions1D.mean, BinFunctions1D.rms, BinFunctions1D.quantile(0.25), BinFunctions1D.median, BinFunctions1D.quantile(0.75), BinFunctions1D.stdDev, BinFunctions1D.min, BinFunctions1D.max};
        String string4 = "%1.2G";
        System.out.println(new Formatter(string4).toTitleString(DoubleFactory2D.dense.make(dArrayArray), stringArray2, stringArray, string, string2, string3, binFunction1DArray));
    }

    protected String form(DoubleMatrix1D doubleMatrix1D, int n, Format format) {
        double d = doubleMatrix1D.get(n);
        if (format == null || d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY || d != d) {
            return String.valueOf(d);
        }
        return format.form(d);
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Format format) {
        return this.form((DoubleMatrix1D)abstractMatrix1D, n, format);
    }

    public String[][] format(DoubleMatrix2D doubleMatrix2D) {
        String[][] stringArray = new String[doubleMatrix2D.rows()][doubleMatrix2D.columns()];
        int n = doubleMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(doubleMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((DoubleMatrix2D)abstractMatrix2D);
    }

    protected int indexOfDecimalPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.lastIndexOf(101);
        }
        if (n < 0) {
            n = string.lastIndexOf(69);
        }
        if (n < 0) {
            n = string.length();
        }
        return n;
    }

    protected int lead(String string) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(string);
        }
        return super.lead(string);
    }

    public String toSourceCode(DoubleMatrix1D doubleMatrix1D) {
        Formatter formatter = (Formatter)this.clone();
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        String string = "{";
        String string2 = "};";
        return string + formatter.toString(doubleMatrix1D) + string2;
    }

    public String toSourceCode(DoubleMatrix2D doubleMatrix2D) {
        Formatter formatter = (Formatter)this.clone();
        String string = this.blanks(3);
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        formatter.setRowSeparator("},\n" + string + "{");
        String string2 = "{\n" + string + "{";
        String string3 = "}\n};";
        return string2 + formatter.toString(doubleMatrix2D) + string3;
    }

    public String toSourceCode(DoubleMatrix3D doubleMatrix3D) {
        Formatter formatter = (Formatter)this.clone();
        String string = this.blanks(3);
        String string2 = this.blanks(6);
        formatter.setPrintShape(false);
        formatter.setColumnSeparator(", ");
        formatter.setRowSeparator("},\n" + string2 + "{");
        formatter.setSliceSeparator("}\n" + string + "},\n" + string + "{\n" + string2 + "{");
        String string3 = "{\n" + string + "{\n" + string2 + "{";
        String string4 = "}\n" + string + "}\n}";
        return string3 + formatter.toString(doubleMatrix3D) + string4;
    }

    public String toString(DoubleMatrix1D doubleMatrix1D) {
        DoubleMatrix2D doubleMatrix2D = doubleMatrix1D.like2D(1, doubleMatrix1D.size());
        doubleMatrix2D.viewRow(0).assign(doubleMatrix1D);
        return this.toString(doubleMatrix2D);
    }

    public String toString(DoubleMatrix2D doubleMatrix2D) {
        return super.toString(doubleMatrix2D);
    }

    public String toString(DoubleMatrix3D doubleMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        int n = 0;
        while (n < doubleMatrix3D.slices()) {
            if (n != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(doubleMatrix3D.viewSlice(n)));
            ++n;
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, AbstractFormatter.shape(doubleMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((DoubleMatrix2D)abstractMatrix2D);
    }

    protected String toTitleString(DoubleMatrix2D doubleMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        if (doubleMatrix2D.size() == 0) {
            return "Empty matrix";
        }
        Object[][] objectArray = this.format(doubleMatrix2D);
        this.align((String[][])objectArray);
        return new cern.colt.matrix.objectalgo.Formatter().toTitleString(ObjectFactory2D.dense.make(objectArray), stringArray, stringArray2, string, string2, string3);
    }

    public String toTitleString(DoubleMatrix2D doubleMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3, BinFunction1D[] binFunction1DArray) {
        int n;
        Object object;
        if (doubleMatrix2D.size() == 0) {
            return "Empty matrix";
        }
        if (binFunction1DArray == null || binFunction1DArray.length == 0) {
            return this.toTitleString(doubleMatrix2D, stringArray, stringArray2, string, string2, string3);
        }
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.like(doubleMatrix2D.rows(), binFunction1DArray.length);
        DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D.like(binFunction1DArray.length, doubleMatrix2D.columns());
        Statistic.aggregate(doubleMatrix2D, binFunction1DArray, doubleMatrix2D3);
        Statistic.aggregate(doubleMatrix2D.viewDice(), binFunction1DArray, doubleMatrix2D2.viewDice());
        DoubleMatrix2D doubleMatrix2D4 = doubleMatrix2D.like(doubleMatrix2D.rows() + binFunction1DArray.length, doubleMatrix2D.columns());
        doubleMatrix2D4.viewPart(0, 0, doubleMatrix2D.rows(), doubleMatrix2D.columns()).assign(doubleMatrix2D);
        doubleMatrix2D4.viewPart(doubleMatrix2D.rows(), 0, binFunction1DArray.length, doubleMatrix2D.columns()).assign(doubleMatrix2D3);
        doubleMatrix2D3 = null;
        Object[][] objectArray = this.format(doubleMatrix2D4);
        this.align((String[][])objectArray);
        doubleMatrix2D4 = null;
        Object[][] objectArray2 = this.format(doubleMatrix2D2);
        this.align((String[][])objectArray2);
        doubleMatrix2D2 = null;
        ObjectMatrix2D objectMatrix2D = ObjectFactory2D.dense.make(doubleMatrix2D.rows() + binFunction1DArray.length, doubleMatrix2D.columns() + binFunction1DArray.length + 1);
        objectMatrix2D.viewPart(0, 0, doubleMatrix2D.rows() + binFunction1DArray.length, doubleMatrix2D.columns()).assign(objectArray);
        objectMatrix2D.viewColumn(doubleMatrix2D.columns()).assign("|");
        objectMatrix2D.viewPart(0, doubleMatrix2D.columns() + 1, doubleMatrix2D.rows(), binFunction1DArray.length).assign(objectArray2);
        objectArray = null;
        objectArray2 = null;
        if (stringArray2 != null) {
            object = new ObjectArrayList(stringArray2);
            ((ObjectArrayList)object).add("|");
            n = 0;
            while (n < binFunction1DArray.length) {
                ((ObjectArrayList)object).add(binFunction1DArray[n].name());
                ++n;
            }
            stringArray2 = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray2);
        }
        if (stringArray != null) {
            object = new ObjectArrayList(stringArray);
            n = 0;
            while (n < binFunction1DArray.length) {
                ((ObjectArrayList)object).add(binFunction1DArray[n].name());
                ++n;
            }
            stringArray = new String[((ObjectArrayList)object).size()];
            ((ObjectArrayList)object).toArray(stringArray);
        }
        object = new cern.colt.matrix.objectalgo.Formatter().toTitleString(objectMatrix2D, stringArray, stringArray2, string, string2, string3);
        int n2 = n = ((String)object).length() + 1;
        int n3 = Math.max(0, string == null ? 0 : string.length() - doubleMatrix2D.rows() - binFunction1DArray.length);
        int n4 = 0;
        while (n4 < binFunction1DArray.length + 1 + n3) {
            n2 = n;
            n = ((String)object).lastIndexOf(this.rowSeparator, n - 1);
            ++n4;
        }
        StringBuffer stringBuffer = new StringBuffer((String)object);
        stringBuffer.insert(n2, this.rowSeparator + this.repeat('-', n2 - n - 1));
        return stringBuffer.toString();
    }

    public String toTitleString(DoubleMatrix3D doubleMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4, BinFunction1D[] binFunction1DArray) {
        if (doubleMatrix3D.size() == 0) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < doubleMatrix3D.slices()) {
            if (n != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(doubleMatrix3D.viewSlice(n), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[n], binFunction1DArray));
            ++n;
        }
        return stringBuffer.toString();
    }

    private String xtoTitleString(DoubleMatrix3D doubleMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4) {
        if (doubleMatrix3D.size() == 0) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < doubleMatrix3D.slices()) {
            if (n != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(doubleMatrix3D.viewSlice(n), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }
}

