/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.bitvector;

import cern.colt.PersistentObject;
import cern.colt.bitvector.QuickBitVector;
import cern.colt.function.IntProcedure;

public class BitVector
extends PersistentObject {
    protected long[] bits;
    protected int nbits;

    public BitVector(long[] lArray, int n) {
        this.elements(lArray, n);
    }

    public BitVector(int n) {
        this(QuickBitVector.makeBitVector(n, 1), n);
    }

    public void and(BitVector bitVector) {
        if (this == bitVector) {
            return;
        }
        this.checkSize(bitVector);
        long[] lArray = this.bits;
        long[] lArray2 = bitVector.bits;
        int n = lArray.length;
        while (--n >= 0) {
            int n2 = n;
            lArray[n2] = lArray[n2] & lArray2[n];
        }
    }

    public void andNot(BitVector bitVector) {
        this.checkSize(bitVector);
        long[] lArray = this.bits;
        long[] lArray2 = bitVector.bits;
        int n = lArray.length;
        while (--n >= 0) {
            int n2 = n;
            lArray[n2] = lArray[n2] & (lArray2[n] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int cardinality() {
        int n = 0;
        int n2 = this.numberOfFullUnits();
        long[] lArray = this.bits;
        int n3 = n2;
        while (--n3 >= 0) {
            long l = lArray[n3];
            if (l == -1L) {
                n += 64;
                continue;
            }
            if (l == 0L) continue;
            int n4 = 64;
            while (--n4 >= 0) {
                if ((l & 1L << n4) == 0L) continue;
                ++n;
            }
        }
        int n5 = this.numberOfBitsInPartialUnit();
        while (--n5 >= 0) {
            if ((lArray[n2] & 1L << n5) == 0L) continue;
            ++n;
        }
        return n;
    }

    protected static void checkRangeFromTo(int n, int n2, int n3) {
        if (n < 0 || n > n2 || n2 >= n3) {
            throw new IndexOutOfBoundsException("from: " + n + ", to: " + n2 + ", size=" + n3);
        }
    }

    protected void checkSize(BitVector bitVector) {
        if (this.nbits > bitVector.size()) {
            throw new IllegalArgumentException("Incompatible sizes: size=" + this.nbits + ", other.size()=" + bitVector.size());
        }
    }

    public void clear() {
        long[] lArray = this.bits;
        int n = lArray.length;
        while (--n >= 0) {
            lArray[n] = 0L;
        }
    }

    public void clear(int n) {
        if (n < 0 || n >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        QuickBitVector.clear(this.bits, n);
    }

    public Object clone() {
        BitVector bitVector = (BitVector)super.clone();
        if (this.bits != null) {
            bitVector.bits = (long[])this.bits.clone();
        }
        return bitVector;
    }

    public BitVector copy() {
        return (BitVector)this.clone();
    }

    public long[] elements() {
        return this.bits;
    }

    public void elements(long[] lArray, int n) {
        if (n < 0 || n > lArray.length * 64) {
            throw new IllegalArgumentException();
        }
        this.bits = lArray;
        this.nbits = n;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof BitVector)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitVector bitVector = (BitVector)object;
        if (this.size() != bitVector.size()) {
            return false;
        }
        int n2 = n = this.numberOfFullUnits();
        while (--n2 >= 0) {
            if (this.bits[n2] == bitVector.bits[n2]) continue;
            return false;
        }
        int n3 = n * 64;
        int n4 = this.numberOfBitsInPartialUnit();
        while (--n4 >= 0) {
            if (this.get(n3) != bitVector.get(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean forEachIndexFromToInState(int n, int n2, boolean bl, IntProcedure intProcedure) {
        int n3;
        if (this.nbits == 0) {
            return true;
        }
        BitVector.checkRangeFromTo(n, n2, this.nbits);
        long[] lArray = this.bits;
        int n4 = QuickBitVector.unit(n);
        int n5 = QuickBitVector.unit(n2);
        int n6 = n;
        int n7 = QuickBitVector.offset(n);
        if (n7 > 0) {
            n3 = Math.min(n2 - n + 1, 64 - n7);
            while (--n3 >= 0) {
                if (QuickBitVector.get(lArray, n6) == bl && !intProcedure.apply(n6)) {
                    return false;
                }
                ++n6;
            }
            ++n4;
        }
        if (n6 > n2) {
            return true;
        }
        n7 = QuickBitVector.offset(n2);
        if (n7 < 63) {
            --n5;
            n3 = n7 + 1;
        } else {
            n3 = 0;
        }
        long l = bl ? 0L : -1L;
        int n8 = n4;
        while (n8 <= n5) {
            long l2 = lArray[n8];
            if (l2 != l) {
                int n9;
                int n10;
                if (bl) {
                    n10 = 0;
                    n9 = 64;
                    while (--n9 >= 0) {
                        if ((l2 & 1L << n10++) != 0L && !intProcedure.apply(n6)) {
                            return false;
                        }
                        ++n6;
                    }
                } else {
                    n10 = 0;
                    n9 = 64;
                    while (--n9 >= 0) {
                        if ((l2 & 1L << n10++) == 0L && !intProcedure.apply(n6)) {
                            return false;
                        }
                        ++n6;
                    }
                }
            } else {
                n6 += 64;
            }
            ++n8;
        }
        while (--n3 >= 0) {
            if (QuickBitVector.get(lArray, n6) == bl && !intProcedure.apply(n6)) {
                return false;
            }
            ++n6;
        }
        return true;
    }

    public boolean get(int n) {
        if (n < 0 || n >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return QuickBitVector.get(this.bits, n);
    }

    public long getLongFromTo(int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 == 0) {
            return 0L;
        }
        if (n < 0 || n >= this.nbits || n2 < 0 || n2 >= this.nbits || n3 < 0 || n3 > 64) {
            throw new IndexOutOfBoundsException("from:" + n + ", to:" + n2);
        }
        return QuickBitVector.getLongFromTo(this.bits, n, n2);
    }

    public boolean getQuick(int n) {
        return QuickBitVector.get(this.bits, n);
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int indexOfFromTo(int n, int n2, boolean bl) {
        IndexProcedure indexProcedure = new IndexProcedure();
        this.forEachIndexFromToInState(n, n2, bl, indexProcedure);
        return indexProcedure.foundPos;
    }

    public void not() {
        long[] lArray = this.bits;
        int n = lArray.length;
        while (--n >= 0) {
            lArray[n] = lArray[n] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    protected int numberOfBitsInPartialUnit() {
        return QuickBitVector.offset(this.nbits);
    }

    protected int numberOfFullUnits() {
        return QuickBitVector.unit(this.nbits);
    }

    public void or(BitVector bitVector) {
        if (this == bitVector) {
            return;
        }
        this.checkSize(bitVector);
        long[] lArray = this.bits;
        long[] lArray2 = bitVector.bits;
        int n = lArray.length;
        while (--n >= 0) {
            int n2 = n;
            lArray[n2] = lArray[n2] | lArray2[n];
        }
    }

    public BitVector partFromTo(int n, int n2) {
        if (this.nbits == 0 || n2 == n - 1) {
            return new BitVector(0);
        }
        BitVector.checkRangeFromTo(n, n2, this.nbits);
        int n3 = n2 - n + 1;
        BitVector bitVector = new BitVector(n3);
        bitVector.replaceFromToWith(0, n3 - 1, this, n);
        return bitVector;
    }

    public void put(int n, boolean bl) {
        if (n < 0 || n >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (bl) {
            QuickBitVector.set(this.bits, n);
        } else {
            QuickBitVector.clear(this.bits, n);
        }
    }

    public void putLongFromTo(long l, int n, int n2) {
        int n3 = n2 - n + 1;
        if (n3 == 0) {
            return;
        }
        if (n < 0 || n >= this.nbits || n2 < 0 || n2 >= this.nbits || n3 < 0 || n3 > 64) {
            throw new IndexOutOfBoundsException("from:" + n + ", to:" + n2);
        }
        QuickBitVector.putLongFromTo(this.bits, l, n, n2);
    }

    public void putQuick(int n, boolean bl) {
        if (bl) {
            QuickBitVector.set(this.bits, n);
        } else {
            QuickBitVector.clear(this.bits, n);
        }
    }

    public void replaceFromToWith(int n, int n2, BitVector bitVector, int n3) {
        int n4;
        if (this.nbits == 0 || n2 == n - 1) {
            return;
        }
        BitVector.checkRangeFromTo(n, n2, this.nbits);
        int n5 = n2 - n + 1;
        if (n3 < 0 || n3 + n5 > bitVector.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (bitVector.bits == this.bits && n <= n3 && n3 <= n2) {
            bitVector = bitVector.copy();
        }
        long[] lArray = this.bits;
        long[] lArray2 = bitVector.bits;
        int n6 = n2 - n + 1;
        int n7 = n4 = QuickBitVector.unit(n6);
        while (--n7 >= 0) {
            long l = QuickBitVector.getLongFromTo(lArray2, n3, n3 + 63);
            QuickBitVector.putLongFromTo(lArray, l, n, n + 63);
            n3 += 64;
            n += 64;
        }
        int n8 = QuickBitVector.offset(n6);
        long l = QuickBitVector.getLongFromTo(lArray2, n3, n3 + n8 - 1);
        QuickBitVector.putLongFromTo(lArray, l, n, n + n8 - 1);
    }

    public void replaceFromToWith(int n, int n2, boolean bl) {
        if (this.nbits == 0 || n2 == n - 1) {
            return;
        }
        BitVector.checkRangeFromTo(n, n2, this.nbits);
        long[] lArray = this.bits;
        int n3 = QuickBitVector.unit(n);
        int n4 = QuickBitVector.offset(n);
        int n5 = QuickBitVector.unit(n2);
        int n6 = QuickBitVector.offset(n2);
        int n7 = 64;
        long l = bl ? -1L : 0L;
        int n8 = n;
        if (n3 == n5) {
            QuickBitVector.putLongFromTo(lArray, l, n8, n8 + n2 - n);
            return;
        }
        QuickBitVector.putLongFromTo(lArray, l, n8, n8 + n6 - n4);
        n8 += n6 - n4 + 1;
        ++n3;
        if (n6 < n7 - 1) {
            --n5;
        }
        int n9 = n3;
        while (n9 <= n5) {
            lArray[n9++] = l;
        }
        if (n3 <= n5) {
            n8 += (n5 - n3 + 1) * n7;
        }
        if (n6 < n7 - 1) {
            QuickBitVector.putLongFromTo(lArray, l, n8, n2);
        }
    }

    public void set(int n) {
        if (n < 0 || n >= this.nbits) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        QuickBitVector.set(this.bits, n);
    }

    public void setSize(int n) {
        if (n != this.size()) {
            BitVector bitVector = new BitVector(n);
            bitVector.replaceFromToWith(0, Math.min(this.size(), n) - 1, this, 0);
            this.elements(bitVector.elements(), n);
        }
    }

    public int size() {
        return this.nbits;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.nbits);
        String string = "";
        stringBuffer.append('{');
        int n = 0;
        while (n < this.nbits) {
            if (this.get(n)) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n);
            }
            ++n;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void xor(BitVector bitVector) {
        this.checkSize(bitVector);
        long[] lArray = this.bits;
        long[] lArray2 = bitVector.bits;
        int n = lArray.length;
        while (--n >= 0) {
            int n2 = n;
            lArray[n2] = lArray[n2] ^ lArray2[n];
        }
    }

    private class IndexProcedure
    implements IntProcedure {
        private int foundPos = -1;

        private IndexProcedure() {
        }

        public boolean apply(int n) {
            this.foundPos = n;
            return false;
        }
    }
}

