/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class ConditionalExpression
extends Expression {
    public static final Role<Expression> CONDITION_ROLE = Roles.CONDITION;
    public static final TokenRole QUESTION_MARK_ROLE = new TokenRole("?", 2);
    public static final Role<Expression> TRUE_ROLE = new Role<Expression>("True", Expression.class, Expression.NULL);
    public static final TokenRole COLON_ROLE = new TokenRole(":", 2);
    public static final Role<Expression> FALSE_ROLE = new Role<Expression>("False", Expression.class, Expression.NULL);

    public ConditionalExpression(Expression condition, Expression trueExpression, Expression falseExpression) {
        super(condition.getOffset());
        this.addChild(condition, CONDITION_ROLE);
        this.addChild(trueExpression, TRUE_ROLE);
        this.addChild(falseExpression, FALSE_ROLE);
    }

    public final JavaTokenNode getQuestionMark() {
        return this.getChildByRole(QUESTION_MARK_ROLE);
    }

    public final JavaTokenNode getColonToken() {
        return this.getChildByRole(COLON_ROLE);
    }

    public final Expression getCondition() {
        return this.getChildByRole(CONDITION_ROLE);
    }

    public final void setCondition(Expression value) {
        this.setChildByRole(CONDITION_ROLE, value);
    }

    public final Expression getTrueExpression() {
        return this.getChildByRole(TRUE_ROLE);
    }

    public final void setTrueExpression(Expression value) {
        this.setChildByRole(TRUE_ROLE, value);
    }

    public final Expression getFalseExpression() {
        return this.getChildByRole(FALSE_ROLE);
    }

    public final void setFalseExpression(Expression value) {
        this.setChildByRole(FALSE_ROLE, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitConditionalExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof ConditionalExpression) {
            ConditionalExpression otherCondition = (ConditionalExpression)other;
            return !other.isNull() && this.getCondition().matches(otherCondition.getCondition(), match) && this.getTrueExpression().matches(otherCondition.getTrueExpression(), match) && this.getFalseExpression().matches(otherCondition.getFalseExpression(), match);
        }
        return false;
    }
}

