/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TokenWeightUtil {
    public static String RESPONSE_KEY = "response";

    public static List<Map<String, Float>> fetchListOfTokenWeightMap(List<Map<String, ?>> mapResultList) {
        if (null == mapResultList || mapResultList.isEmpty()) {
            throw new IllegalArgumentException("The inference result can not be null or empty.");
        }
        ArrayList results = new ArrayList();
        for (Map<String, ?> map : mapResultList) {
            if (!map.containsKey(RESPONSE_KEY)) {
                throw new IllegalArgumentException("The inference result should be associated with the field [" + RESPONSE_KEY + "].");
            }
            if (!List.class.isAssignableFrom(map.get(RESPONSE_KEY).getClass())) {
                throw new IllegalArgumentException("The data object associated with field [" + RESPONSE_KEY + "] should be a list.");
            }
            results.addAll((List)map.get("response"));
        }
        return results.stream().map(TokenWeightUtil::buildTokenWeightMap).collect(Collectors.toList());
    }

    private static Map<String, Float> buildTokenWeightMap(Object uncastedMap) {
        if (!Map.class.isAssignableFrom(uncastedMap.getClass())) {
            throw new IllegalArgumentException("The expected inference result is a Map with String keys and Float values.");
        }
        HashMap<String, Float> result = new HashMap<String, Float>();
        for (Map.Entry entry : ((Map)uncastedMap).entrySet()) {
            if (!String.class.isAssignableFrom(entry.getKey().getClass()) || !Number.class.isAssignableFrom(entry.getValue().getClass())) {
                throw new IllegalArgumentException("The expected inference result is a Map with String keys and Float values.");
            }
            result.put((String)entry.getKey(), Float.valueOf(((Number)entry.getValue()).floatValue()));
        }
        return result;
    }
}

