"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.skippingIndexDataMock = exports.skippingIndexBuilderMockResult2 = exports.skippingIndexBuilderMockResult1 = exports.skippingIndexBuilderMock2 = exports.skippingIndexBuilderMock1 = exports.materializedViewValidDataMock = exports.materializedViewStaleDataMock = exports.materializedViewEmptyTumbleDataMock = exports.materializedViewEmptyDataMock = exports.materializedViewBuilderMockResult2 = exports.materializedViewBuilderMockResult1 = exports.materializedViewBuilderMock2 = exports.materializedViewBuilderMock1 = exports.indexOptionsMockResult6 = exports.indexOptionsMockResult5 = exports.indexOptionsMockResult4 = exports.indexOptionsMockResult3 = exports.indexOptionsMockResult2 = exports.indexOptionsMockResult1 = exports.indexOptionsMock6 = exports.indexOptionsMock5 = exports.indexOptionsMock4 = exports.indexOptionsMock3 = exports.indexOptionsMock2 = exports.indexOptionsMock1 = exports.createAccelerationEmptyDataMock = exports.coveringIndexDataMock = exports.coveringIndexBuilderMockResult2 = exports.coveringIndexBuilderMockResult1 = exports.coveringIndexBuilderMock2 = exports.coveringIndexBuilderMock1 = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const skippingIndexDataMock = exports.skippingIndexDataMock = [{
  id: '1',
  fieldName: 'field1',
  dataType: 'string',
  accelerationMethod: 'PARTITION'
}, {
  id: '2',
  fieldName: 'field2',
  dataType: 'number',
  accelerationMethod: 'VALUE_SET'
}];
const coveringIndexDataMock = exports.coveringIndexDataMock = ['field1', 'field2', 'field3'];
const materializedViewEmptyDataMock = exports.materializedViewEmptyDataMock = {
  columnsValues: [],
  groupByTumbleValue: {
    timeField: '',
    tumbleWindow: 0,
    tumbleInterval: ''
  }
};
const materializedViewEmptyTumbleDataMock = exports.materializedViewEmptyTumbleDataMock = {
  columnsValues: [{
    id: '1',
    functionName: 'count',
    functionParam: 'field1'
  }],
  groupByTumbleValue: {
    timeField: '',
    tumbleWindow: 0,
    tumbleInterval: 'second'
  }
};
const materializedViewStaleDataMock = exports.materializedViewStaleDataMock = {
  columnsValues: [],
  groupByTumbleValue: {
    timeField: 'timestamp',
    tumbleWindow: 10,
    tumbleInterval: 'hour'
  }
};
const materializedViewValidDataMock = exports.materializedViewValidDataMock = {
  columnsValues: [{
    id: '1',
    functionName: 'count',
    functionParam: 'field1'
  }, {
    id: '2',
    functionName: 'sum',
    functionParam: 'field2'
  }],
  groupByTumbleValue: {
    timeField: 'timestamp',
    tumbleWindow: 5,
    tumbleInterval: 'hour'
  }
};
const createAccelerationEmptyDataMock = exports.createAccelerationEmptyDataMock = {
  dataSource: '',
  dataTable: '',
  database: '',
  dataTableFields: [],
  accelerationIndexType: 'skipping',
  skippingIndexQueryData: [],
  coveringIndexQueryData: [],
  materializedViewQueryData: {
    columnsValues: [],
    groupByTumbleValue: {
      timeField: '',
      tumbleWindow: 0,
      tumbleInterval: ''
    }
  },
  accelerationIndexName: _constants.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME,
  primaryShardsCount: 5,
  replicaShardsCount: 1,
  refreshType: 'auto',
  checkpointLocation: undefined,
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: _constants.ACCELERATION_TIME_INTERVAL[1].value
  },
  watermarkDelay: {
    delayWindow: 1,
    delayInterval: _constants.ACCELERATION_TIME_INTERVAL[1].value
  },
  formErrors: {
    dataSourceError: [],
    databaseError: [],
    dataTableError: [],
    skippingIndexError: [],
    coveringIndexError: [],
    materializedViewError: [],
    indexNameError: [],
    primaryShardsError: [],
    replicaShardsError: [],
    refreshIntervalError: [],
    checkpointLocationError: [],
    watermarkDelayError: []
  }
};
const indexOptionsMock1 = exports.indexOptionsMock1 = {
  ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'auto'
};
const indexOptionsMockResult1 = exports.indexOptionsMockResult1 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = true
)`;
const indexOptionsMock2 = exports.indexOptionsMock2 = {
  ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 10,
    refreshInterval: 'minute'
  }
};
const indexOptionsMockResult2 = exports.indexOptionsMockResult2 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = true,
refresh_interval = '10 minutes'
)`;
const indexOptionsMock3 = exports.indexOptionsMock3 = {
  ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'auto',
  checkpointLocation: 's3://path/to/checkpoint'
};
const indexOptionsMockResult3 = exports.indexOptionsMockResult3 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = true,
checkpoint_location = 's3://path/to/checkpoint'
)`;
const indexOptionsMock4 = exports.indexOptionsMock4 = {
  ...createAccelerationEmptyDataMock,
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'manual'
};
const indexOptionsMockResult4 = exports.indexOptionsMockResult4 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = false
)`;
const indexOptionsMock5 = exports.indexOptionsMock5 = {
  ...createAccelerationEmptyDataMock,
  accelerationIndexType: 'materialized',
  primaryShardsCount: 3,
  replicaShardsCount: 2,
  refreshType: 'manual',
  watermarkDelay: {
    delayWindow: 10,
    delayInterval: 'minute'
  }
};
const indexOptionsMockResult5 = exports.indexOptionsMockResult5 = `WITH (
index_settings = '{"number_of_shards":3,"number_of_replicas":2}',
auto_refresh = false,
watermark_delay = '10 minutes'
)`;
const skippingIndexBuilderMock1 = exports.skippingIndexBuilderMock1 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  skippingIndexQueryData: [{
    id: '1',
    fieldName: 'field1',
    dataType: 'string',
    accelerationMethod: 'PARTITION'
  }, {
    id: '2',
    fieldName: 'field2',
    dataType: 'int',
    accelerationMethod: 'VALUE_SET'
  }, {
    id: '3',
    fieldName: 'field3',
    dataType: 'boolean',
    accelerationMethod: 'MIN_MAX'
  }],
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
const indexOptionsMock6 = exports.indexOptionsMock6 = {
  ...createAccelerationEmptyDataMock,
  primaryShardsCount: 1,
  replicaShardsCount: 1,
  refreshType: 'manual',
  checkpointLocation: 's3://dsfsad/dasda'
};
const indexOptionsMockResult6 = exports.indexOptionsMockResult6 = `WITH (
index_settings = '{"number_of_shards":1,"number_of_replicas":1}',
auto_refresh = false
)`;
const skippingIndexBuilderMockResult1 = exports.skippingIndexBuilderMockResult1 = `CREATE SKIPPING INDEX
ON datasource.database.table (
   \`field1\` PARTITION, 
   \`field2\` VALUE_SET, 
   \`field3\` MIN_MAX
  ) WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = true,
refresh_interval = '1 minute',
checkpoint_location = 's3://test/'
)`;
const skippingIndexBuilderMock2 = exports.skippingIndexBuilderMock2 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  skippingIndexQueryData: [{
    id: '1',
    fieldName: 'field1',
    dataType: 'string',
    accelerationMethod: 'PARTITION'
  }],
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/'
};
const skippingIndexBuilderMockResult2 = exports.skippingIndexBuilderMockResult2 = `CREATE SKIPPING INDEX
ON datasource.database.table (
   \`field1\` PARTITION
  ) WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
checkpoint_location = 's3://test/'
)`;
const coveringIndexBuilderMock1 = exports.coveringIndexBuilderMock1 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  coveringIndexQueryData: ['field1', 'field2', 'field3'],
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
const coveringIndexBuilderMockResult1 = exports.coveringIndexBuilderMockResult1 = `CREATE INDEX index_name
ON datasource.database.table (
   \`field1\`, 
   \`field2\`, 
   \`field3\`
  ) WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = true,
refresh_interval = '1 minute',
checkpoint_location = 's3://test/'
)`;
const coveringIndexBuilderMock2 = exports.coveringIndexBuilderMock2 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexName: 'index_name',
  coveringIndexQueryData: ['field1'],
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/'
};
const coveringIndexBuilderMockResult2 = exports.coveringIndexBuilderMockResult2 = `CREATE INDEX index_name
ON datasource.database.table (
   \`field1\`
  ) WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
checkpoint_location = 's3://test/'
)`;
const materializedViewBuilderMock1 = exports.materializedViewBuilderMock1 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexType: 'materialized',
  accelerationIndexName: 'index_name',
  materializedViewQueryData: {
    columnsValues: [{
      id: '1',
      functionName: 'count',
      functionParam: 'field',
      fieldAlias: 'counter'
    }, {
      id: '2',
      functionName: 'count',
      functionParam: '*',
      fieldAlias: 'counter1'
    }, {
      id: '3',
      functionName: 'sum',
      functionParam: 'field2'
    }, {
      id: '4',
      functionName: 'avg',
      functionParam: 'field3',
      fieldAlias: 'average'
    }],
    groupByTumbleValue: {
      timeField: 'timestamp',
      tumbleWindow: 1,
      tumbleInterval: 'minute'
    }
  },
  primaryShardsCount: 9,
  replicaShardsCount: 2,
  refreshType: 'interval',
  refreshIntervalOptions: {
    refreshWindow: 1,
    refreshInterval: 'minute'
  },
  watermarkDelay: {
    delayWindow: 1,
    delayInterval: 'minute'
  },
  checkpointLocation: 's3://test/'
};
const materializedViewBuilderMockResult1 = exports.materializedViewBuilderMockResult1 = `CREATE MATERIALIZED VIEW datasource.database.index_name
AS SELECT
   count(\`field\`) AS \`counter\`, 
   count(*) AS \`counter1\`, 
   sum(\`field2\`), 
   avg(\`field3\`) AS \`average\`
FROM datasource.database.table
GROUP BY TUMBLE (\`timestamp\`, '1 minute')
 WITH (
index_settings = '{"number_of_shards":9,"number_of_replicas":2}',
auto_refresh = true,
refresh_interval = '1 minute',
watermark_delay = '1 minute',
checkpoint_location = 's3://test/'
)`;
const materializedViewBuilderMock2 = exports.materializedViewBuilderMock2 = {
  ...createAccelerationEmptyDataMock,
  dataSource: 'datasource',
  database: 'database',
  dataTable: 'table',
  accelerationIndexType: 'materialized',
  accelerationIndexName: 'index_name',
  materializedViewQueryData: {
    columnsValues: [{
      id: '1',
      functionName: 'count',
      functionParam: 'field'
    }],
    groupByTumbleValue: {
      timeField: 'timestamp',
      tumbleWindow: 2,
      tumbleInterval: 'hour'
    }
  },
  primaryShardsCount: 5,
  replicaShardsCount: 3,
  refreshType: 'auto',
  checkpointLocation: 's3://test/',
  watermarkDelay: {
    delayWindow: 2,
    delayInterval: 'minute'
  }
};
const materializedViewBuilderMockResult2 = exports.materializedViewBuilderMockResult2 = `CREATE MATERIALIZED VIEW datasource.database.index_name
AS SELECT
   count(\`field\`)
FROM datasource.database.table
GROUP BY TUMBLE (\`timestamp\`, '2 hours')
 WITH (
index_settings = '{"number_of_shards":5,"number_of_replicas":3}',
auto_refresh = true,
watermark_delay = '2 minutes',
checkpoint_location = 's3://test/'
)`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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