/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ResettableSystemProperties
implements AutoCloseable {
    private final Map<String, String> toRestore;

    public ResettableSystemProperties(Map<String, String> toSet) {
        Objects.requireNonNull(toSet);
        if (toSet.isEmpty()) {
            this.toRestore = Collections.emptyMap();
            return;
        }
        this.toRestore = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : toSet.entrySet()) {
            String oldValue = System.setProperty(entry.getKey(), entry.getValue());
            this.toRestore.put(entry.getKey(), oldValue);
        }
    }

    public static ResettableSystemProperties of(String name, String value) {
        return new ResettableSystemProperties(Map.of(name, value));
    }

    public static ResettableSystemProperties empty() {
        return new ResettableSystemProperties(Collections.emptyMap());
    }

    @Override
    public void close() {
        for (Map.Entry<String, String> entry : this.toRestore.entrySet()) {
            if (entry.getValue() != null) {
                System.setProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.clearProperty(entry.getKey());
        }
    }
}

