/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config.database;

import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.Option;

public final class Database {
    private static final Map<String, Vendor> DATABASES = new HashMap<String, Vendor>();

    public static boolean isLiquibaseDatabaseSupported(String databaseType, String dbKind) {
        for (Vendor vendor : DATABASES.values()) {
            if (!vendor.liquibaseType.equals(databaseType) || !vendor.isOfKind(dbKind)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Vendor> getVendor(String vendor) {
        return Arrays.stream(Vendor.values()).filter(v -> v.isOfKind(vendor) || Arrays.asList(v.aliases).contains(vendor)).findAny();
    }

    public static Optional<String> getDatabaseKind(String alias) {
        return Database.mapValue(alias, vendor -> vendor.databaseKind);
    }

    public static Optional<String> getDefaultUrl(String namedProperty, String alias) {
        return Database.getVendor(alias).map(f -> f.defaultUrl.apply(namedProperty, alias));
    }

    public static Optional<String> getDriver(String alias, boolean isXaEnabled) {
        return Database.mapValue(alias, vendor -> isXaEnabled ? vendor.xaDriver : vendor.nonXaDriver);
    }

    public static Optional<String> getDialect(String alias) {
        return Database.mapValue(alias, vendor -> vendor.dialect.apply(alias));
    }

    private static <T> Optional<T> mapValue(String alias, Function<Vendor, T> mapper) {
        return Database.getVendor(alias).map(mapper);
    }

    public static List<String> getDatabaseAliases() {
        return DATABASES.keySet().stream().sorted().collect(Collectors.toList());
    }

    static {
        for (Vendor vendor : Vendor.values()) {
            for (String alias : vendor.aliases) {
                DATABASES.put(alias, vendor);
            }
        }
    }

    public static enum Vendor {
        H2("h2", "org.h2.jdbcx.JdbcDataSource", "org.h2.Driver", "org.hibernate.dialect.H2Dialect", new BiFunction<String, String, String>(){

            @Override
            public String apply(String namedProperty, String alias) {
                if ("dev-file".equalsIgnoreCase(alias)) {
                    String separator = this.escapeReplacements(File.separator);
                    return "jdbc:h2:file:" + "${kc.db-url-path:${kc.home.dir:%s}}".formatted(this.escapeReplacements(System.getProperty("user.home"))) + separator + "${kc.data.dir:data}" + separator + this.getFolder(namedProperty) + separator + this.getDbName(namedProperty);
                }
                return "jdbc:h2:mem:%s".formatted(this.getDbName(namedProperty));
            }

            private String getFolder(String namedProperty) {
                return StringUtil.isNullOrEmpty((String)namedProperty) ? "h2" : "h2-%s".formatted(namedProperty);
            }

            private String getDbName(String namedProperty) {
                return StringUtil.isNullOrEmpty((String)namedProperty) ? "keycloakdb" : "keycloakdb-%s".formatted(namedProperty);
            }

            private String escapeReplacements(String snippet) {
                if (File.separator.equals("\\")) {
                    return snippet.replace("\\", "/");
                }
                return snippet;
            }
        }, "liquibase.database.core.H2Database", "dev-mem", "dev-file"),
        MYSQL("mysql", "com.mysql.cj.jdbc.MysqlXADataSource", "com.mysql.cj.jdbc.Driver", "org.hibernate.dialect.MySQLDialect", (namedProperty, alias) -> "jdbc:mysql://%s:%s/%s%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "3306"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak"), Vendor.getProperty(DatabaseOptions.DB_URL_PROPERTIES, namedProperty)), "org.keycloak.connections.jpa.updater.liquibase.UpdatedMySqlDatabase", new String[0]),
        TIDB("tidb", "com.mysql.cj.jdbc.MysqlXADataSource", "com.mysql.cj.jdbc.Driver", "org.hibernate.community.dialect.TiDBDialect", (namedProperty, alias) -> "jdbc:mysql://%s:%s/%s%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "3306"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak"), Vendor.getProperty(DatabaseOptions.DB_URL_PROPERTIES, namedProperty)), "org.keycloak.connections.jpa.updater.liquibase.UpdatedMySqlDatabase", new String[0]),
        MARIADB("mariadb", "org.mariadb.jdbc.MariaDbDataSource", "org.mariadb.jdbc.Driver", "org.hibernate.dialect.MariaDBDialect", (namedProperty, alias) -> "jdbc:mariadb://%s:%s/%s%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "3306"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak"), Vendor.getProperty(DatabaseOptions.DB_URL_PROPERTIES, namedProperty)), "org.keycloak.connections.jpa.updater.liquibase.UpdatedMariaDBDatabase", new String[0]),
        POSTGRES("postgresql", "org.postgresql.xa.PGXADataSource", "org.postgresql.Driver", "org.hibernate.dialect.PostgreSQLDialect", (namedProperty, alias) -> "jdbc:postgresql://%s:%s/%s%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "5432"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak"), Vendor.getProperty(DatabaseOptions.DB_URL_PROPERTIES, namedProperty)), "liquibase.database.core.PostgresDatabase", "postgres"),
        MSSQL("mssql", "com.microsoft.sqlserver.jdbc.SQLServerXADataSource", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServerDialect", (namedProperty, alias) -> "jdbc:sqlserver://%s:%s;databaseName=%s%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "1433"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak"), Vendor.getProperty(DatabaseOptions.DB_URL_PROPERTIES, namedProperty)), "org.keycloak.quarkus.runtime.storage.database.liquibase.database.CustomMSSQLDatabase", "mssql"),
        ORACLE("oracle", "oracle.jdbc.xa.client.OracleXADataSource", "oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.OracleDialect", (namedProperty, alias) -> "jdbc:oracle:thin:@//%s:%s/%s".formatted(Vendor.getProperty(DatabaseOptions.DB_URL_HOST, namedProperty, "localhost"), Vendor.getProperty(DatabaseOptions.DB_URL_PORT, namedProperty, "1521"), Vendor.getProperty(DatabaseOptions.DB_URL_DATABASE, namedProperty, "keycloak")), "liquibase.database.core.OracleDatabase", new String[0]);

        final String databaseKind;
        final String xaDriver;
        final String nonXaDriver;
        final Function<String, String> dialect;
        final BiFunction<String, String, String> defaultUrl;
        final String liquibaseType;
        final String[] aliases;

        private Vendor(String databaseKind, String xaDriver, String nonXaDriver, String dialect, BiFunction<String, String, String> defaultUrl, String liquibaseType, String ... aliases) {
            this(databaseKind, xaDriver, nonXaDriver, (String alias) -> dialect, defaultUrl, liquibaseType, aliases);
        }

        private Vendor(String databaseKind, String xaDriver, String nonXaDriver, Function<String, String> dialect, BiFunction<String, String, String> defaultUrl, String liquibaseType, String ... aliases) {
            String[] stringArray;
            this.databaseKind = databaseKind;
            this.xaDriver = xaDriver;
            this.nonXaDriver = nonXaDriver;
            this.dialect = dialect;
            this.defaultUrl = defaultUrl;
            this.liquibaseType = liquibaseType;
            if (aliases.length == 0) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = databaseKind;
            } else {
                stringArray = aliases;
            }
            this.aliases = stringArray;
        }

        public boolean isOfKind(String dbKind) {
            return this.databaseKind.equals(dbKind);
        }

        private static String getProperty(Option<?> option, String namedProperty) {
            return Vendor.getProperty(option, namedProperty, "");
        }

        private static String getProperty(Option<?> option, String namedProperty, String defaultValue) {
            return "${kc.%s:%s}".formatted(StringUtil.isNullOrEmpty((String)namedProperty) ? option.getKey() : DatabaseOptions.Datasources.getNamedKey(option, namedProperty).orElseThrow(() -> new IllegalArgumentException("Cannot find the named property")), defaultValue);
        }

        public String getLiquibaseType() {
            return this.liquibaseType;
        }

        public String toString() {
            return this.databaseKind.toLowerCase(Locale.ROOT);
        }
    }
}

