# Copyright Advanced Micro Devices, Inc., or its affiliates.
# SPDX-License-Identifier:  MIT

include(CMakeFindDependencyMacro)

find_dependency(hipblas-common)

include("${CMAKE_CURRENT_LIST_DIR}/hipblaslt-targets.cmake")

block(SCOPE_FOR VARIABLES)
    if(NOT TARGET roc::hipblaslt)
        message(FATAL_ERROR "roc::hipblaslt target is missing")
    endif()

    get_target_property(link_libraries roc::hipblaslt INTERFACE_LINK_LIBRARIES)

    if(link_libraries AND "hip::device" IN_LIST link_libraries)
        message(FATAL_ERROR "Do not export targets with hip::device as an interface link library")
    endif()
endblock()
