/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.function.filesleuth.data.DateRange;
import tim.prune.function.filesleuth.gui.DateRangeUser;
import tim.prune.function.filesleuth.gui.MonthCombo;
import tim.prune.gui.GuiGridLayout;
import tim.prune.gui.IconManager;
import tim.prune.gui.StatusIcon;
import tim.prune.gui.WholeNumberField;

public class DateRangeEditor
extends JDialog {
    private final DateRangeUser _parent;
    private JTabbedPane _tabs = null;
    private WholeNumberField _yearField0 = null;
    private WholeNumberField _yearField1 = null;
    private WholeNumberField _yearField2 = null;
    private MonthCombo _monthField0 = null;
    private MonthCombo _monthField1 = null;
    private MonthCombo _monthField2 = null;
    private WholeNumberField _dayField0 = null;
    private WholeNumberField _dayField1 = null;
    private WholeNumberField _dayField2 = null;
    private JTextField _resultField0 = null;
    private JTextField _resultField1 = null;
    private StatusIcon _statusIcon0 = null;
    private StatusIcon _statusIcon1 = null;
    private JButton _okButton = null;

    public DateRangeEditor(JDialog jDialog, DateRangeUser dateRangeUser, IconManager iconManager) {
        super(jDialog, I18nManager.getText("dialog.editdaterange.title"), true);
        this._parent = dateRangeUser;
        this.setLocationRelativeTo(jDialog);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.makeDialogComponents(iconManager));
        this.pack();
    }

    private JPanel makeDialogComponents(IconManager iconManager) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.editdaterange.desc")), "North");
        this._tabs = new JTabbedPane();
        jPanel.add((Component)this._tabs, "Center");
        PreviewListener previewListener = new PreviewListener();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.year")));
        this._yearField0 = new WholeNumberField(4);
        this._yearField0.addKeyListener(previewListener);
        guiGridLayout.add(this._yearField0);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.month")));
        this._monthField0 = new MonthCombo();
        this._monthField0.addKeyListener(previewListener);
        this._monthField0.addItemListener(previewListener);
        guiGridLayout.add(this._monthField0);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.day")));
        this._dayField0 = new WholeNumberField(2);
        this._dayField0.addKeyListener(previewListener);
        guiGridLayout.add(this._dayField0);
        guiGridLayout.addVerticalGap(8);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.result")));
        this._resultField0 = new JTextField(10);
        this._resultField0.setEditable(false);
        this._statusIcon0 = new StatusIcon(iconManager);
        guiGridLayout.add(this.bundleIntoPanel(this._resultField0, this._statusIcon0));
        this._tabs.add(I18nManager.getText("dialog.editdaterange.yearmonthday"), jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        double[] dArray = new double[]{0.5, 1.0, 0.0, 1.0};
        boolean[] blArray = new boolean[4];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] blArray2 = blArray;
        guiGridLayout = new GuiGridLayout(jPanel3, dArray, blArray2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.year")));
        this._yearField1 = new WholeNumberField(4);
        this._yearField1.addKeyListener(previewListener);
        guiGridLayout.add(this._yearField1);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.to")));
        this._yearField2 = new WholeNumberField(4);
        this._yearField2.addKeyListener(previewListener);
        guiGridLayout.add(this._yearField2);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.month")));
        this._monthField1 = new MonthCombo();
        guiGridLayout.add(this._monthField1);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.to")));
        this._monthField2 = new MonthCombo();
        guiGridLayout.add(this._monthField2);
        this._monthField1.addItemListener(itemEvent -> this.monthChanged(this._monthField1, this._monthField2));
        this._monthField2.addItemListener(itemEvent -> this.monthChanged(this._monthField2, this._monthField1));
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.day")));
        this._dayField1 = new WholeNumberField(2);
        this._dayField1.addKeyListener(previewListener);
        guiGridLayout.add(this._dayField1);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.to")));
        this._dayField2 = new WholeNumberField(2);
        this._dayField2.addKeyListener(previewListener);
        guiGridLayout.add(this._dayField2);
        guiGridLayout.addVerticalGap(8);
        guiGridLayout.add(new JLabel(I18nManager.getText("dialog.editdaterange.result")));
        this._resultField1 = new JTextField(22);
        this._resultField1.setEditable(false);
        this._statusIcon1 = new StatusIcon(iconManager);
        guiGridLayout.add(this.bundleIntoPanel(this._resultField1, this._statusIcon1), 3, false);
        this._tabs.add(I18nManager.getText("dialog.editdaterange.daterange"), jPanel3);
        this._tabs.addChangeListener(changeEvent -> this.preview());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> this.finish();
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this.dispose());
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private JPanel bundleIntoPanel(JTextField jTextField, StatusIcon statusIcon) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jTextField, "Center");
        jPanel.add((Component)statusIcon, "East");
        return jPanel;
    }

    private void monthChanged(MonthCombo monthCombo, MonthCombo monthCombo2) {
        boolean bl;
        boolean bl2 = monthCombo.getSelectedIndex() == 0;
        boolean bl3 = bl = monthCombo2.getSelectedIndex() == 0;
        if (bl2 != bl) {
            monthCombo2.setSelectedIndex(monthCombo.getSelectedIndex());
        }
        this.preview();
    }

    public void show(String string) {
        DateRange dateRange = DateRange.parseString(string);
        if (dateRange == null || dateRange.isEmpty() || !dateRange.isValid()) {
            int n = Calendar.getInstance().get(1);
            this._yearField0.setText("" + n);
            this._yearField1.setText("" + n);
            this._yearField2.setText("" + n);
            this._tabs.setSelectedIndex(0);
        } else if (dateRange.isYearMonthDay()) {
            String string2 = dateRange.toShortString();
            boolean bl = string2.length() > 4;
            boolean bl2 = string2.length() == 10;
            this._yearField0.setValue(dateRange.getDateFrom().getYear());
            this._monthField0.setSelectedIndex(bl ? dateRange.getDateFrom().getMonth() : 0);
            this._dayField0.setText(bl2 ? String.valueOf(dateRange.getDateFrom().getDay()) : "");
            this._tabs.setSelectedIndex(0);
        } else {
            this._yearField1.setValue(dateRange.getDateFrom().getYear());
            this._yearField2.setValue(dateRange.getDateTo().getYear());
            this._monthField1.setSelectedIndex(dateRange.getDateFrom().getMonth());
            this._monthField2.setSelectedIndex(dateRange.getDateTo().getMonth());
            this._dayField1.setText(String.valueOf(dateRange.getDateFrom().getDay()));
            this._dayField2.setText(String.valueOf(dateRange.getDateTo().getDay()));
            this._tabs.setSelectedIndex(1);
        }
        this.preview();
        this.setVisible(true);
    }

    private void preview() {
        boolean bl;
        DateRange dateRange = this.getDateRange();
        boolean bl2 = bl = dateRange != null && dateRange.isValid();
        if (this._tabs.getSelectedIndex() == 0) {
            boolean bl3 = this._monthField0.isAllMonths();
            this._dayField0.setEnabled(!bl3);
            if (bl3) {
                this._dayField0.setText("");
                bl = dateRange != null && dateRange.isValid();
            }
            this._resultField0.setText(dateRange == null ? "" : dateRange.toShortString());
            if (bl) {
                this._statusIcon0.setStatusValid();
            } else {
                this._statusIcon0.setStatusInvalid();
            }
        } else {
            boolean bl4 = this._monthField1.isAllMonths();
            this._dayField1.setEnabled(!bl4);
            if (bl4) {
                this._dayField1.setText("");
                this._dayField2.setText("");
            }
            this._dayField2.setEnabled(!bl4);
            this._resultField1.setText(dateRange == null ? "" : dateRange.toString());
            if (bl) {
                this._statusIcon1.setStatusValid();
            } else {
                this._statusIcon1.setStatusInvalid();
            }
        }
        this._okButton.setEnabled(bl);
    }

    private DateRange getDateRange() {
        if (this._tabs.getSelectedIndex() == 0) {
            int n = this._yearField0.getValue();
            int n2 = this._monthField0.getMonthNum();
            int n3 = this._dayField0.getValue();
            return DateRange.parseValues(n, n2, n3);
        }
        int n = this._yearField1.getValue();
        int n4 = this._monthField1.getMonthNum();
        int n5 = this._dayField1.getValue();
        int n6 = this._yearField2.getValue();
        int n7 = this._monthField2.getMonthNum();
        int n8 = this._dayField2.getValue();
        return DateRange.parseValues(n, n4, n5, n6, n7, n8);
    }

    private void finish() {
        DateRange dateRange = this.getDateRange();
        if (dateRange != null && dateRange.isValid()) {
            this._parent.updateDateRange(this.getDateRange());
            this.dispose();
        }
    }

    private class PreviewListener
    implements KeyListener,
    ItemListener {
        private PreviewListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            DateRangeEditor.this.preview();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            DateRangeEditor.this.preview();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

