/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.mem.MemBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class IndependentPairedPcodeExecutorState<L, R>
implements PcodeExecutorState<Pair<L, R>> {
    private final PcodeExecutorStatePiece<L, L> left;
    private final PcodeExecutorStatePiece<R, R> right;
    private final PcodeArithmetic<Pair<L, R>> arithmetic;

    public IndependentPairedPcodeExecutorState(PcodeExecutorStatePiece<L, L> left, PcodeExecutorStatePiece<R, R> right, PcodeArithmetic<Pair<L, R>> arithmetic) {
        this.left = left;
        this.right = right;
        this.arithmetic = arithmetic;
    }

    public IndependentPairedPcodeExecutorState(PcodeExecutorStatePiece<L, L> left, PcodeExecutorStatePiece<R, R> right) {
        this(left, right, new PairedPcodeArithmetic<L, R>(left.getArithmetic(), right.getArithmetic()));
    }

    @Override
    public Language getLanguage() {
        return this.left.getLanguage();
    }

    @Override
    public PcodeArithmetic<Pair<L, R>> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public Stream<PcodeExecutorStatePiece<?, ?>> streamPieces() {
        return Stream.of(this.left, this.right).flatMap(p -> p.streamPieces());
    }

    @Override
    public IndependentPairedPcodeExecutorState<L, R> fork(PcodeStateCallbacks cb) {
        return new IndependentPairedPcodeExecutorState<L, R>(this.left.fork(cb), this.right.fork(cb), this.arithmetic);
    }

    @Override
    public Map<Register, Pair<L, R>> getRegisterValues() {
        Map<Register, L> leftRVs = this.left.getRegisterValues();
        Map<Register, R> rightRVs = this.right.getRegisterValues();
        HashSet<Register> union = new HashSet<Register>();
        union.addAll(leftRVs.keySet());
        union.addAll(rightRVs.keySet());
        HashMap<Register, Pair<L, R>> result = new HashMap<Register, Pair<L, R>>();
        for (Register k : union) {
            result.put(k, Pair.of(leftRVs.get(k), rightRVs.get(k)));
        }
        return result;
    }

    @Override
    public void setVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, Pair<L, R> val) {
        this.left.setVar(space, offset.getLeft(), size, quantize, val.getLeft());
        this.right.setVar(space, offset.getRight(), size, quantize, val.getRight());
    }

    @Override
    public void setVarInternal(AddressSpace space, Pair<L, R> offset, int size, Pair<L, R> val) {
        this.left.setVarInternal(space, offset.getLeft(), size, val.getLeft());
        this.right.setVarInternal(space, offset.getRight(), size, val.getRight());
    }

    @Override
    public Pair<L, R> getVar(AddressSpace space, Pair<L, R> offset, int size, boolean quantize, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVar(space, offset.getLeft(), size, quantize, reason), this.right.getVar(space, offset.getRight(), size, quantize, reason));
    }

    @Override
    public Pair<L, R> getVarInternal(AddressSpace space, Pair<L, R> offset, int size, PcodeExecutorStatePiece.Reason reason) {
        return Pair.of(this.left.getVarInternal(space, offset.getLeft(), size, reason), this.right.getVarInternal(space, offset.getRight(), size, reason));
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address, PcodeArithmetic.Purpose purpose) {
        return this.left.getConcreteBuffer(address, purpose);
    }

    public PcodeExecutorStatePiece<L, L> getLeft() {
        return this.left;
    }

    public PcodeExecutorStatePiece<R, R> getRight() {
        return this.right;
    }

    @Override
    public void clear() {
        this.left.clear();
        this.right.clear();
    }
}

